///////////////////////////////////////////////////////////////////////
//
// MHHillas
//
// This class contains histograms for every Hillas parameter
//
///////////////////////////////////////////////////////////////////////

#include "MHHillas.h"

#include <TH1.h>
#include <TPad.h>
#include <TCanvas.h>

#include "MHillas.h"

ClassImp(MHHillas)

MHHillas::MHHillas (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHHillas" ;
    *fTitle = title ? title : "Container for Hillas histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fAlpha  = new TH1F("Alpha [deg]", "Alpha of Hillas",   90, 0,  90);
    fWidth  = new TH1F("Width [mm]",  "Width of Hillas",  100, 0, 300);
    fLength = new TH1F("Length [mm]", "Length of Hillas", 100, 0, 300);
    fDist   = new TH1F("Dist [mm]",   "Dist of Hillas",   100, 0, 300);
}

MHHillas::~MHHillas()
{
    delete fAlpha;
    delete fWidth;
    delete fLength;
    delete fDist;
}

void MHHillas::Fill(MHillas *par)
{
    fAlpha ->Fill(fabs(par->GetAlpha()));
    fWidth ->Fill(par->GetWidth());
    fLength->Fill(par->GetLength());
    fDist  ->Fill(par->GetDist());
}

void MHHillas::Draw(Option_t *)
{

    //
    // Fixme! Check for an existing canvas.
    // And create one if no canvas exists only!
    //
    TCanvas *c = new TCanvas("Hillas", "Histograms of Hillas Parameters");
    c->Divide(2,2);

    c->cd(1);
    fAlpha->Draw();
    c->cd(2);
    fLength->Draw();
    c->cd(3);
    fDist->Draw();
    c->cd(4);
    fWidth->Draw();

    c->Modified();
    c->Update();
}
