Double_t GetResidual(Double_t fRawEl,  Double_t fRawAz,
                     Double_t fStarEl, Double_t fStarAz)
{
    fRawEl *= TMath::DegToRad();
    fRawAz *= TMath::DegToRad();
    fStarEl *= TMath::DegToRad();
    fStarAz *= TMath::DegToRad();
    Double_t del = fRawEl-fStarEl;
    Double_t daz = fRawAz-fStarAz;
    Double_t dphi2 = daz/2.;
    Double_t cos2  = cos(dphi2)*cos(dphi2);
    Double_t sin2  = sin(dphi2)*sin(dphi2);
    Double_t d = cos(del)*cos2 - cos(fRawEl+fStarEl)*sin2;

    Double_t dist = acos(d);

    return dist * TMath::RadToDeg();
}

void DrawMarker(TVirtualPad *pad, Double_t r0, Double_t phi0, Double_t r1, Double_t phi1)
    {
        TView *view = pad->GetView();

        if (!view)
        {
            cout << "No View!" << endl;
            return;
        }

        TMarker mark0;
        TMarker mark1;
        mark0.SetMarkerStyle(kStar);
        mark1.SetMarkerStyle(kStar);
        mark1.SetMarkerColor(kRed);
    
        r0 /= 90;
        r1 /= 90;
        phi0 *= TMath::DegToRad();
        phi1 *= TMath::DegToRad();
    
        Double_t x0[3] = { r0*cos(phi0), r0*sin(phi0), 0};
        Double_t x1[3] = { r1*cos(phi1), r1*sin(phi1), 0};

        mark0.DrawMarker(x0[0], x0[1]);
        mark1.DrawMarker(x1[0], x1[1]);

        return;
        Double_t y0[3], y1[3];
    
        view->WCtoNDC(x0, y0);
        view->WCtoNDC(x1, y1);
    
        mark0.DrawMarker(y0[0], y0[1]);
        mark1.DrawMarker(y1[0], y1[1]);
    }

int fill(const char *fname, TGraph *g, TH1 *h)
{
/*
    TH2F h2res1("Res2D1", " Dataset positions on the sky ", 32, 0, 360,  10, 0, 90);
    h2res1.SetBit(TH1::kNoStats);
    h2res1.DrawCopy("surf1pol");
    gPad->Modified();
    gPad->Update();
    gPad->SetTheta(90);
    gPad->SetPhi(-90);

    DrawMarker(gPad, 45, 0, 0, 0);
    gPad->Modified();
    gPad->Update();

    return;

  */
    ifstream fin(fname);

    while (1)
    {
        TString str;
        str.ReadLine(fin);
        if (!fin)
            break;

        if (str.Contains("#"))
            continue;

        Float_t alt, az, dalt, daz, mjd;
        sscanf(str.Data(), "%f %f %*f %*f %*f %*f %f %f %f",
               &alt, &az, &dalt, &daz, &mjd);

        if (dalt==0/* ||  GetResidual(alt, az, alt+dalt, az+daz)>0.1*/)
            continue;

        //cout << dalt << " " << daz << " " << GetResidual(alt, az, alt+dalt, az+daz) << endl;

        mjd -=  53140.097505;

        Double_t res = GetResidual(alt, az, alt-dalt, az-daz);

        g[0].SetPoint(g[0].GetN(), g[0].GetN(), fabs(dalt));
        g[1].SetPoint(g[1].GetN(), g[1].GetN(), fabs(daz));
        g[2].SetPoint(g[2].GetN(), g[2].GetN(), res);

        h->Fill(res);
    }

    return g[0].GetN();
}

void plot()
{
    TGraph g[3];

    TH1F h0("0404", "TPoints Residuals 4/2004",  35, 0, 0.2);
    TH1F h1("0405", "TPoints Residuals 5/2004",  35, 0, 0.2);
    TH1F h2("0408", "TPoints Residuals 8/2004",  35, 0, 0.2);
    TH1F h3("0409", "TPoints Residuals 9/2004",  35, 0, 0.2);
    TH1F h4("0410", "TPoints Residuals 10/2004", 35, 0, 0.2);
    TH1F h5("0411", "TPoints Residuals 11/2004", 35, 0, 0.2);
    TH1F h6("0412", "TPoints Residuals 12/2004", 35, 0, 0.2);
    TH1F h7("0503", "TPoints Residuals 3/2005",  35, 0, 0.2);
    TH1F h8("0504", "TPoints Residuals 4/2005",  35, 0, 0.2);

    TH1 *h[9] = { &h0, &h1, &h2, &h3, &h4, &h5, &h6, &h7, &h8 };

    TArrayI n(9);
    n[0] = fill("tpoint0404.txt", g, &h0);
    n[1] = fill("tpoint0405.txt", g, &h1);
    n[2] = fill("tpoint0408.txt", g, &h2);
    n[3] = fill("tpoint0409.txt", g, &h3);
    n[4] = fill("tpoint0410.txt", g, &h4);
    n[5] = fill("tpoint0411.txt", g, &h5);
    n[6] = fill("tpoint0412.txt", g, &h6);
    n[7] = fill("tpoint0503.txt", g, &h7);
    n[8] = fill("tpoint0504.txt", g, &h8);

//    for (int i=0; i<n.GetSize(); i++)
//        cout << "Overflows: " << Form("%4.0f", h[i]->GetBinContent(h[i]->GetNbinsX()+1)*h[i]->GetEntries()/h[i]->GetEntries()) << "/" << Form("%4.0f", h[i]->GetEntries()) << endl;

    g[0].SetMarkerColor(kGreen);
    g[1].SetMarkerColor(kMagenta);
    g[2].SetMarkerColor(kBlack);
    //g[2].SetLineColor(kBlack);
    g[0].SetMarkerStyle(kFullDotMedium);
    g[1].SetMarkerStyle(kFullDotMedium);
    g[2].SetMarkerStyle(kFullDotLarge);

    // --------- First Canvas ----------

    new TCanvas("Vs Time", "");

    TObject *obj[4];

    for (int i=0; i<3; i++)
    {
        g[i].SetFillColor(kWhite);
        g[i].SetLineColor(kWhite);
        obj[i] = g[i].Clone();
        obj[i]->SetBit(kCanDelete);
        obj[i]->Draw(i==0?"AP":"P");
    }

    TLegend leg(0.905, 0.86, 0.99, 0.99);
    leg.AddEntry(obj[0], "  \\Delta\\theta");
    leg.AddEntry(obj[1], "  \\Delta\\phi");
    leg.AddEntry(obj[2], "  \\Delta");
    leg.DrawClone()->SetBit(kCanDelete);

    TLine l;
    l.SetLineColor(kBlue);
    for (int i=0; i<n.GetSize(); i++)
        l.DrawLine(n[i], gPad->GetUymin(), n[i], gPad->GetUymax());

    // --------- Second Canvas ----------

    new TCanvas("Distrib", "");

    Double_t max = 0;
    for (int i=0; i<n.GetSize(); i++)
    {
        h[i]->Scale(1./h[i]->GetEntries());
        max = TMath::Max(max, h[i]->GetMaximum());
    }
    for (int i=0; i<n.GetSize(); i++)
        h[i]->SetMaximum(max*1.05);

    h0.SetLineColor(kYellow);
    h1.SetLineColor(kGreen);
    h2.SetLineColor(kBlue);
    //h3.SetLineColor(kYellow);

    h7.DrawCopy();
    h0.DrawCopy("same");
    h1.DrawCopy("same");
    h2.DrawCopy("same");
    h3.DrawCopy("same");
    h4.DrawCopy("same");
    h5.DrawCopy("same");
    h6.DrawCopy("same");
    h7.DrawCopy("same");

    return;

    for (int i=0; i<n.GetSize(); i++)
    {
        cout << "Mean:  " << Form("%.3f +- %.3f", h[i]->GetMean(), h[i]->GetRMS());
        cout << "   (Overflows=" << h[i]->GetBinContent(h[i]->GetNbinsX()+1)*h[i]->GetEntries() << ")" << endl;
    }
}
