#ifndef MARS_MHDisp
#define MARS_MHDisp

#ifndef MARS_MHFalseSource
#include "MHFalseSource.h"
#endif

class MParList;
class MHillasExt;
class MParameterD;

class MHDisp : public MHFalseSource
{
private:
    MHillasExt  *fHilExt;
    MParameterD *fDisp;

    Double_t fM3lCut;
    Double_t fXi;
    Double_t fXiTheta;

public:
    MHDisp(const char *name=NULL, const char *title=NULL);

    // MH
    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    void Paint(Option_t *o="");
    void Draw(Option_t *o="");

    ClassDef(MHDisp, 1) //3D-histogram in alpha, x and y
};

#endif
