///////////////////////////////////////////////////////////////////////
//
// MHStarMap
//
// This class contains a 2-dimensional histogram. It should show some
// kind of star map. The algorith which calculates the star map
// from the Hillas parameters (Fill) can be enhanced.
//
///////////////////////////////////////////////////////////////////////

#include "MHStarMap.h"

#include <TH2.h>
#include <TStyle.h>
#include <TCanvas.h>

#include "MHillas.h"

ClassImp(MHStarMap)

MHStarMap::MHStarMap (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHStarMap" ;
    *fTitle = title ? title : "Container for a Star Map" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fStarMap = new TH2F("Star Map", "Counts",
                        50, -300, 300,
                        50, -300, 300);
}

MHStarMap::~MHStarMap()
{
    delete fStarMap;
}

void MHStarMap::Draw(Option_t *)
{
    TCanvas *c = new TCanvas("Star Map", "Star Map created from Hillas Parameters", 500, 500);

    gStyle->SetPalette(1, 0);
    fStarMap->Draw("colz");

    c->Modified();
    c->Update();
}

void MHStarMap::Fill(MHillas *par)
{
    const float dist  = par->GetDist();
    const float theta = par->GetTheta();
    const float alpha = par->GetAlpha()/kRad2Deg;

    const float m = tan(theta+alpha-kPI);
    const float t = dist*(sin(theta)-cos(theta)*m);

    float y0 = -m*300+t;
    for (int i=-297; i<300; i+=3)
    {
        const float y1 = m*i+t;

//        if (y1<=y0-3 || y1>=y0+3)
//            continue;

        fStarMap->Fill(i, y1);
        y0 = y1;
    }
}

