#ifndef MARS_MRFEnergyEst
#define MARS_MRFEnergyEst

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class TArrayD;

class MHMatrix;
class MDataArray;
class MParameterD;

class MRFEnergyEst : public MTask
{
private:
    Int_t        fNumTrees;  // Training parameters
    Int_t        fNumTry;    // Training parameters
    Int_t        fNdSize;    // Training parameters

    TString      fFileName;
    TObjArray    fEForests;

    MDataArray  *fData;       //! Used to store the MDataChains to get the event values
    MParameterD *fEnergyEst;  //! Used to storeestimated energy

    MHMatrix *fTestMatrix;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    Int_t ReadForests(MParList *plist=NULL);

public:
    MRFEnergyEst(const char *name=NULL, const char *title=NULL);

    void  SetFileName(TString str)     { fFileName = str; }

    void  SetNumTrees(Int_t n=-1)   { fNumTrees = n; }
    void  SetNdSize(Int_t n=-1)     { fNdSize   = n; }
    void  SetNumTry(Int_t n=-1)     { fNumTry   = n; }

    void  SetTestMatrix(MHMatrix *m=0) { fTestMatrix=m; }
    void  InitMapping(MHMatrix *m=0)   { fTestMatrix=m; }

    Int_t Train(const MHMatrix &n, const TArrayD &grid);

    ClassDef(MRFEnergyEst, 0) // Task
};

#endif
