#include "MMonteCarlo.h"

#include <TGButton.h>       // TGTextButton

ClassImp(MMonteCarlo)

enum {
    M_BUTTON_ACTION
};

MMonteCarlo::MMonteCarlo(const TGWindow *main, const TGWindow *p, 
                                   const UInt_t w, const UInt_t h )
    : MBrowser(p, main, w, h)
{

    fButAction = new TGTextButton(fTop1, "ACTION", M_BUTTON_ACTION );
    fButAction->Associate(this) ;
    fTop1->AddFrame (fButAction, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    MapSubwindows();

    Layout();

    SetWindowName("MonteCarlo Main");
    SetIconName("MonteCarlo");

    MapWindow();
} 

MMonteCarlo::~MMonteCarlo()
{
    delete fButAction;
}

// ======================================================================

Bool_t MMonteCarlo::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{     
    if (GET_MSG(msg) == kC_COMMAND &&
        GET_SUBMSG(msg) == kCM_BUTTON &&
        parm1 == M_BUTTON_ACTION)
    {
        DisplInfo("Put Intelligence here!");
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
}
