void optimdisp()
{
    MJOptimizeDisp opt;
    opt.SetDebug(2);
    opt.SetOptimizer(MJOptimize::kSimplex);
    opt.EnableTestTrain();

    // -------------------- Setup ----------------------------
    //opt.AddParameter("1-(MHillas.fWidth/MHillas.fLength)");
    opt.AddParameter("atan(1./(1-(MHillas.fWidth/MHillas.fLength)))");
    //opt.AddParameter("log10(MNewImagePar.fLeakage1+1)");

    opt.FixParameter(0, 0.743871,  0,  2);  //0.562676
    opt.FixParameter(1, 0.329471,  0,  2);  //0.317315
    opt.FixParameter(2, 1.500002,  0, 10);  //1.55754

    // Leakage==0: RMS = 0.030
    // Leakage>0:  RMS = 0.010

    // all: 0.029 (0.605991, 0.332266, 1.50825)

    //char *r = "([0]+(pow(M[1],[1])*[2]))/M[0]";
    //char *r = "([0]+(pow(M[1],[1])*[2]))*M[0]";
    //char *r = "[0]*M[0]";
    char *r = "[0]/M[0]";

    // -------------------- Run ----------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    opt.AddPreCut("MNewImagePar.fLeakage1<0.0001");
    opt.RunDisp("ganymedmcpart.root", r);
}
