void CT1Hillas()
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a CT1 dataset.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist->AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamCT1 geomcam;
    plist->AddToList(&geomcam);

    //
    // The Hillas histograms (MHHillas) could be created automatically
    // but to make sure, that they are not deleted when the macro is
    // finished you must create them yourself and add it to the list
    //
    MHHillas  *hists = new MHHillas;
    plist->AddToList(hists);

    MHStarMap *smap = new MHStarMap;
    plist->AddToList(smap);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a ct1 ascii file
    //  2) clean the image
    //  3) calculate hillas
    //  4) fill the hillas into the histograms
    //
    MCT1ReadAscii read;
    read.AddFile("CT1_99_off1.dat");
    read.AddFile("CT1_99_off2.dat");

    MImgCleanStd  clean;
    MHillasCalc   hcalc;
    MFillHHillas  hfill;
    MFillHStarMap sfill;

    tlist.AddToList(&read);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    evtloop.Eventloop();

    //
    // After the analysis is finished we can display the histograms
    //
    hists->Draw();
    smap->Draw();
}
