/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 05/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// createdataset.C
// ===============
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TEnv.h>

#include <MSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TSystem.h>

using namespace std;



int createdataset(Int_t dataset, TString source, TString wobble,
                  Bool_t cal=kFALSE,
                  TString startdate="0000-00-00 00:00:00",
                  TString stopdate="3000-00-00 00:00:00",
                  TString off="none",
                  TString offstartdate="0000-00-00 00:00:00",
                  TString offstopdate="3000-00-00 00:00:00")
{
    TEnv env("sql.rc");

    MSQLServer serv(env);
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "createdataset" << endl;
    cout << "-------------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    TString fname(Form("/magic/datasets/%05d/dataset%08d.txt", dataset/1000, dataset));
    TString fhtml="/home/operator/html";
    Bool_t exist=gSystem->AccessPathName(fname,kFileExists);
    if (exist==0)
    {
        cout << fname << " already exists, please choose different dataset#" << endl;
        return 0;
    }

    ofstream fouthtml(fhtml, ios::app);
    fouthtml << "<tr><td>" << endl;
    fouthtml << dataset << endl;
    fouthtml << "</td><td>" << endl;
    fouthtml << source << endl;
    fouthtml << "</td><td>" << endl;
    if (startdate=="0000-00-00 00:00:00")
        fouthtml << "all" << endl;
    else
        fouthtml << "from " << startdate << " to " << stopdate << endl;
    if (cal)
        fouthtml << "only data processed to the imgpar is taken into account" << endl;
    fouthtml << "</td></tr>" << endl;

    ofstream fout(fname, ios::app);
    cout << "writing to file " << fname << endl;
    fout << "AnalysisNumber: " << dataset << endl << endl;

    TString query="Select Sequences.fSequenceFirst from Sequences left join Source on ";
    query +="Sequences.fSourceKEY=Source.fSourceKEY ";
    if (cal)
        query +=" left join SequenceProcessStatus on Sequences.fSequenceFirst=SequenceProcessStatus.fSequenceFirst ";
    query +=Form(" where fSourceName like '%s%%' and fRunStart between '%s' and '%s'",
                 source.Data(), startdate.Data(), stopdate.Data());
    if (cal)
        query +=" and not IsNull(fStar) ";
    query +=" order by Sequences.fSequenceFirst ";

    cout << "Q: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
    {
        cout << "Error - no sequence found" << endl;
        return 0;
    }

    fout << "SequencesOn: " << flush;
    TSQLRow *row=0;
    while ((row = res->Next()))
        fout << " " << (*row)[0] <<  " " << flush;
    fout << endl << endl;

    delete res;

    if (off.Contains("none"))
    {
        cout << "no off chosen" << endl;
        if (wobble.Contains("Y"))
        {
            cout << "wobble mode -> finished" << endl;
            return 1;
        }
        off  ="Off";
        off +=source.Remove(7,12);
    }

    cout << "off: " << off << endl;
    query  ="Select Sequences.fSequenceFirst from Sequences left join Source on ";
    query +="Sequences.fSourceKEY=Source.fSourceKEY ";
    if (cal)
        query +=" left join SequenceProcessStatus on Sequences.fSequenceFirst=SequenceProcessStatus.fSequenceFirst ";
    query +=Form("where fSourceName like '%s%%' and fRunStart between '%s' and '%s'",
                 off.Data(), offstartdate.Data(), offstopdate.Data());
    if (cal)
        query +=" and not IsNull(fStar) ";
    query +=" order by Sequences.fSequenceFirst ";

    cout << "Q: " << query << endl;

    res = serv.Query(query);
    if (!res)
    {
        cout << "Error - no sequence found" << endl;
        return 0;
    }

    fout << "SequencesOff: " << flush;
    row=0;
    while ((row = res->Next()))
        fout << " " << (*row)[0] <<  " " << flush;
    fout << endl << endl;

    fout << "#SourceName: " << source << endl;
    fout << "Catalog: /magic/datacenter/setup/magic_favorites.edb" << endl;
    if (wobble.Contains("N"))
        fout << "#" << flush;
    fout << "WobbleMode: On" << endl << endl;

    delete res;

    return 1;
}

