/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MMcPedestalCopy                                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MMcPedestalCopy.h"

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MPedestalCam.h"
#include "MMcFadcHeader.hxx"

ClassImp(MMcPedestalCopy)

MMcPedestalCopy::MMcPedestalCopy(const char *name, const char *title)
{
    *fName  = name  ? name  : "MMcPedestalCopy";
    *fTitle = title ? title : "Task to copy monte carlo pedestals into MPedestal Container";
}

Bool_t MMcPedestalCopy::PreProcess( MParList *pList )
{
    fMcPedestals = (MMcFadcHeader*)pList->FindObject("MMcFadcHeader");
    if (!fMcPedestals)
    {
        *fLog << dbginf << "MMcFadcHeader not found... aborting." << endl;
        return kFALSE;
    }

    fPedestals = (MPedestalCam*)pList->FindCreateObj("MPedestalCam");
    if (!fPedestals)
        return kFALSE;

    return kTRUE;
}

Bool_t MMcPedestalCopy::Process()
{
    const int num = fMcPedestals->GetNumPixel();

    fPedestals->InitSize(num);

    for (int i=0; i<num; i++)
    {
        MPedestalPix &pix = (*fPedestals)[i];

        const Float_t pedest = fMcPedestals->GetPedestal(i);
        const Float_t pedrms = fMcPedestals->GetPedestalRms(i);

        const Float_t sigma  = pedest*sqrt(num);
        const Float_t sigrms = sigma/sqrt(2*num);

        pix.SetPedestal(pedest, sigma);
        pix.SetPedestalRms(pedrms, sigrms);

        *fLog << pedest << " " << sigma << " " << pedrms << " " << sigrms << endl;
    }

    return kTRUE;
}

