#ifndef MARS_MHPhi
#define MARS_MHPhi

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHillas;
class MSrcPosCam;
class MParameterD;

class MHPhi : public MH
{
private:
    TH1D fHPhi;

    MHillas     *fHillas;  //!
    MSrcPosCam  *fSrcPos;  //!
    MParameterD *fDisp;    //!

    Double_t fConvMm2Deg;  //!

    Int_t   fNumBinsSignal;
    Float_t fThetaCut;
    Float_t fDistSrc;

public:
    MHPhi(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    void Draw(Option_t *opt="");
    void Paint(Option_t *opt="");

    ClassDef(MHPhi, 1) // Histogram to display information about rate
};

#endif


