#include "MGeomPix.h"

#include "MLog.h"

ClassImp(MGeomPix)

MGeomPix::MGeomPix(Float_t x, Float_t y, Float_t r) : fX(x), fY(y), fR(r)
{
    //  default constructor
}

void MGeomPix::SetNeighbors(Short_t i0, Short_t i1, Short_t i2,
                            Short_t i3, Short_t i4, Short_t i5)
{
    fNeighbors[0] = i0;
    fNeighbors[1] = i1;
    fNeighbors[2] = i2;
    fNeighbors[3] = i3;
    fNeighbors[4] = i4;
    fNeighbors[5] = i5;

    int i;
    for (i=0; i<6; i++)
        if (fNeighbors[i]<0)
            break;

    fNumNeighbors = i;
}


void MGeomPix::Print(Option_t *opt)
{ 
    //   information about a pixel
    gLog << "MPixGeom:  x= " << fX
        << "  y= " << fY
        << "  r= " << fR
        << endl ;
}

