/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug, 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//
//  stdCalib.C
//
//  This macros is based on the calibration macro from Markus Gaug.
//  It processes a Pedestal file and writes a file with the containers
//
//  Needed arguments are retrieved from the file "marsconfig".
//  A typical config file looks like this:
//   inpath:                  /data/MAGIC/Period015/rootdata/2004_03_21/
//   outpath:                 /data/MAGIC/Period015/calibdata/2004_03_21/
//   pedfile:                 21297
//   calfile:                 21297
//
//  inpath:     is the path to the merpped root files
//  outpath:    is the path where to store the F0 files
//  pedfilexxx: specifies which pedestal files to use. If more then 1 file
//              is specified, all files are processed but only 1 output file
//              is written.
//
//  The macro searches for the pulser colour which corresponds to the calibration
//  run number. If the run number is smaller than 20000, pulser colour "CT1"
//  is assumed, otherwise, it searches for the strings "green", "blue", "uv" or
//  "ct1" in the filenames. If no colour or multiple colours are found, the
//  execution is aborted.
//
//  The container MBadPixelsCam is created and followed during the execution of the
//  rest of the macro.
//
//  The container MCalibrationQECam is created and followed during the execution of the
//  rest of the macro.
//
//  A loop over the calibration files is performed using the class MJCalibration.
//  The call to MJCalibration skips the relative time calibration, which can be
//  uncommented as well.
//
/////////////////////////////////////////////////////////////////////////////


//
// Tell if you want to calibrate times:
//
static const  Bool_t useTimes = kTRUE;
//static const  Bool_t useTimes = kFALSE;

void singleCalib()
{

  // turn of colors for logging to a file
  gLog.SetNoColors();

  // Get configuration from the "marsconfig" configuration file.
//  TEnv env("marsconfig");

  // Here we get the input and output directory paths from the configuration
  // file
//  const char* inpath = env.GetValue("inpath",".");
//  const char* outpath = env.GetValue("outpath",".");
//  Int_t prun = env.GetValue( "pedfile", 0);
//  Int_t crun = env.GetValue( "calfile", 0);
  const char* inpath = "/data/MAGIC/Period016/rootdata2/2004_04_16";
  const char* outpath = "/data/MAGIC/Period016/calibdata/2004_04_16";
  Int_t prun = 22351;
  Int_t crun = 22323;


  //
  // Choose the signal Extractor:
  //
  //  MExtractFixedWindowPeakSearch extractor;
  //  MExtractSlidingWindow  extractor;
   MExtractFixedWindow    extractor;

  //
  // Set Ranges or Windows
  //
   extractor.SetRange(3,14,3,14);
  //  extractor.SetWindows(8,8);

  //
  // Choose the arrival time Extractor:
  //
  //  MExtractTimeHighestIntegral timeext;
  MExtractTimeFastSpline timeext;
  //
  // Set Ranges or Windows
  //
  timeext.SetRange(2,12,4,14);

  MRunIter pruns;
  MRunIter cruns;

  pruns.AddRun(prun,inpath);
  cruns.AddRun(crun,inpath);

  gLog << "Perestal Runs: " << pruns.GetRunsAsString()  << " " << pruns.GetNumEntries() << endl;
  gLog << "Calib Runs: " << cruns.GetRunsAsString()  << " " << cruns.GetNumEntries() << endl;

  gStyle->SetOptStat(1);
  gStyle->SetOptFit();

  MStatusDisplay *display = new MStatusDisplay;
  display->SetUpdateTime(3000);
  display->Resize(850,700);

  MCalibrationQECam qecam;
  MBadPixelsCam     badcam;

  //
  // If you want to exclude pixels from the beginning, read
  // an ascii-file with the corr. pixel numbers (see MBadPixelsCam)
  //
//  badcam.AsciiRead("badpixels.dat");


  /************************************/
  /* LOOP1: READ PEDESTAL INFORMATION */
  /************************************/
  MJPedestal    pedloop;
  pedloop.SetInput(&pruns);
  pedloop.SetOutputPath(outpath);       // This is needed to read the pedestal container file

  if (!pedloop.Process())
    return;

  /**********************************/
  /* LOOP2: CALIBRATION COMPUTATION */
  /**********************************/
  MJCalibration calloop;

  //
  // If you want to calibrate the times as well, choose:
  //
  calloop.SetRelTimeCalibration(useTimes);
  calloop.SetExtractor(&extractor);
  calloop.SetTimeExtractor(&timeext);
  calloop.SetInput(&cruns);
  calloop.SetOutputPath(outpath);
  calloop.SetDisplay(display);
  calloop.SetQECam(qecam);
  calloop.SetBadPixels(pedloop.GetBadPixels());

//  TObject::SetObjectStat(kTRUE);

  calloop.Process(pedloop.GetPedestalCam());

//  gObjectTable->Print();

}


