
/********************************************************************\

  Name:         ConsoleCommand.cc

  Created by:   Sebastian Commichau, March 2008
                commichau@phys.ethz.ch

  Actions:      Handle console input

\********************************************************************/
 

#include "ConsoleCommand.h"


void ConsoleCommand(ProcessIO *m) {

  siginterrupt(SIGUSR1, true);

  char comline[MAX_COM_SIZE];

  char str[MAX_COM_SIZE];
  char *c;

  do {
        
    fprintf(stdout,m->status->Prompt);
    c = fgets(comline, MAX_COM_SIZE, stdin);

    m->status->Pc = comline;
    //      sprintf(str,"Test in ConsoleCommand: %s",m->status->Pc);
    //  printf(str);
    /*
    if (strlen(m->status->Pc) < 2 )  // Ignore commands with only '\n'
      continue;
    m->status->Pc[strlen(m->status->Pc)-1]='\0';  // Remove '\n'
    */
    //if(m->status->Pc[0]=='.') {   // Shell command
    //  system(&(m->status->Pc[1]));
    //  continue;
    //}

    
    sprintf(str,"USER> %s",m->status->Pc);
    m->log->LogWrite(str);

    ParseInput(m->status->Pc,&(m->status->NParam),m->status->Param);
     
    pthread_mutex_lock(&m->control_mutex);

    if (m->CommandControl()==0) 
      pthread_cond_broadcast(&m->control_cond);

    pthread_mutex_unlock(&m->control_mutex);      
      
  } while ((c != NULL) && (!m->status->Exit));

}

