#ifndef TIMER_H
#define TIMER_H

#include <unistd.h> // gettimeofday

class Timer
{
private:
    const static int fDays[12];
    double fMs;
    double fDiv;
    int fSec;
    int fSecs;
    int fMin;
    int fHor;
    int fDay;
    int fMon;
    int fYea;

public:
    Timer() : fMs(0), fSec(0), fSecs(0), fMin(0), fHor(0), fDay(0), fMon(0), fYea(0) {}
    Timer(double t);
    Timer(struct timeval *tv);
    Timer(Timer &t);

    void SetTimer(int tv_sec, double tv_usec);
    void SetTimer(struct timeval *tv);


    int GetSecs() { return fSecs; }
    double GetTime();
    double GetMjd();

    void Print();

    operator double();
};

#endif
