#ifndef MCOSY_H
#define MCOSY_H

#include "coord.h"
#include "msgqueue.h"
#include "network.h"

#define kDEG ((char)0xb0)  // Linux ''

#define WM_PRESET    0x1000
#define WM_POSITION  0x1001
#define WM_TRACK     0x1002
#define WM_STOP      0x1003
#define WM_POLARIS   0x1004

class ShaftEncoder;
class Macs;
class MGCosy;

class MCosy : public Network, public MsgQueue
{
private:
    ShaftEncoder *fAlt1;
    ShaftEncoder *fAlt2;
    ShaftEncoder *fAz;

    Macs *fMac1;
    Macs *fMac2;

    MGCosy *fWin;

    pthread_t *fTxThrd;

    ZdAz  fOffset;    // Tracking Offset between SE and calc-pos [re]
    RaDec fRaDec;     // Position to track
    int   fTracking;  // Flag for present tracking action

    static void *MapTalkThread(void *arg);

    ZdAz GetSePos();     // [se]
    ZdAz GetRePos();

    void TalkThread();
    int  SetPosition(const ZdAz &dst);

    void TerminateApp();

    void TrackPosition(const RaDec &dst); // ra, dec [rad]

    int StopWaitingForSDO();

public:
    MCosy(const char *dev, const int baud, ostream &out=cout);
    ~MCosy();

    void Start();
    void Stop();

    void *Proc(int msg, void *mp);

    static ZdAz CorrectTarget(const ZdAz &src, const ZdAz &dst);
    static ZdAz RaDec2ZdAz(const double mjd, const RaDec &pos, const RaDec &pm=RaDec(0,0));
};

#endif
