#ifndef MARS_MRanTree
#define MARS_MRanTree

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class TMatrix;
class TMatrixRow;
class TVector;
class TRandom;

class MRanTree : public MParContainer
{
private:
    Int_t fClassify;
    Int_t fNdSize;
    Int_t fNumTry;

    Int_t fNumNodes;
    Int_t fNumEndNodes;

    TArrayI fBestVar;
    TArrayI fTreeMap1;
    TArrayI fTreeMap2;
    TArrayF fBestSplit;
    TArrayF fGiniDec;

    int (MRanTree::*FindBestSplit)
        (const TArrayI &, const TArrayI &, const TArrayF &, const TArrayI &,
         Int_t, Int_t , TArrayF &, float &, float &, Int_t &, Float_t &,
         Int_t &, const TArrayF &, const int); //!


    int FindBestSplitGini(const TArrayI &datasort, const TArrayI &datarang,
                          const TArrayF &hadtrue, const TArrayI &idclass,
                          Int_t ndstart, Int_t ndend, TArrayF &tclasspop,
                          float &mean, float &square, Int_t &msplit,
                          Float_t &decsplit, Int_t &nbest, const TArrayF &winbag,
                          const int nclass);

    int FindBestSplitSigma(const TArrayI &datasort, const TArrayI &datarang,
                           const TArrayF &hadtrue, const TArrayI &idclass,
                           Int_t ndstart, Int_t ndend, TArrayF &tclasspop,
                           float &mean, float &square, Int_t &msplit,
                           Float_t &decsplit, Int_t &nbest, const TArrayF &winbag,
                           const int nclass);

    void MoveData(TArrayI &datasort, Int_t ndstart, Int_t ndend,
                  TArrayI &idmove, TArrayI &ncase, Int_t msplit,
                  Int_t nbest, Int_t &ndendl);

    void BuildTree(TArrayI &datasort, const TArrayI &datarang, const TArrayF &hadtrue,
                   const TArrayI &idclass,TArrayI &bestsplit,TArrayI &bestsplitnext,
                   TArrayF &tclasspop, float &tmean, float &tsquare, const TArrayF &winbag,
                   Int_t ninbag, const int nclass);

public:
    MRanTree(const char *name=NULL, const char *title=NULL);
    MRanTree(const MRanTree &tree);

    void SetNdSize(Int_t n);
    void SetNumTry(Int_t n);

    Int_t GetNdSize() const { return fNdSize; }
    Int_t GetNumTry() const { return fNumTry; }
    Int_t GetNumNodes()          const { return fNumNodes; }
    Int_t GetNumEndNodes()       const { return fNumEndNodes; }

    Int_t GetBestVar(Int_t i)    const { return fBestVar.At(i); }
    Int_t GetTreeMap1(Int_t i)   const { return fTreeMap1.At(i); }
    Int_t GetTreeMap2(Int_t i)   const { return fTreeMap2.At(i); }
    Int_t GetNodeClass(Int_t i)  const { return fBestVar.At(i)+2; }
    Int_t GetNodeStatus(Int_t i) const { return TMath::Sign(1,fBestVar.At(i));}
    Float_t GetBestSplit(Int_t i)const { return fBestSplit.At(i); }

    Float_t GetGiniDec(Int_t i)  const { return fGiniDec.At(i); }

    void SetClassify(Int_t n){ fClassify=n; }

    // functions used in tree growing process
    void GrowTree(TMatrix *mat, const TArrayF &hadtrue, const TArrayI &idclass,
                  TArrayI &datasort, const TArrayI &datarang,TArrayF &tclasspop,
                  float &mean, float &square, TArrayI &jinbag, const TArrayF &winbag,
                  const int nclass);

    Double_t TreeHad(const TVector &event);
    Double_t TreeHad(const TMatrixRow &event);
    Double_t TreeHad(const TMatrix &m, Int_t ievt);

    Bool_t AsciiWrite(ostream &out) const;

    ClassDef(MRanTree, 1) // Storage container for tree structure
};

#endif
