void rfenergyest()
{
    MSequence seqtst("~/Software/Mars/mranforest/sequencemc-test.txt");
    MSequence seqtrn("~/Software/Mars/mranforest/sequencemc-train.txt");

    if (!seqtst.IsValid())
    {
        cout << "Test sequence not valid" << endl;
        return;
    }
    if (!seqtrn.IsValid())
    {
        cout << "Train sequence not valid" << endl;
        return;
    }

    // --------------------- Setup files --------------------
    MReadMarsFile read("Events");
    MReadMarsFile read2("Events");
    read.DisableAutoScheme();
    read2.DisableAutoScheme();

    MDirIter iter, iter2;
    seqtrn.SetupDatRuns(iter,  MSequence::kImages, "~/Software/mc");
    seqtst.SetupDatRuns(iter2, MSequence::kImages, "~/Software/mc");

    read.AddFiles(iter);
    read2.AddFiles(iter2);

    // ----------------------- Setup RF ----------------------
    MHMatrix train("Train");
    train.AddColumn("MHillas.fSize");
    train.AddColumn("MHillasSrc.fDist");
    train.AddColumn("MPointingPos.fZd");
    /*
     train.AddColumn("MImagePar.fSizeSinglePixels");
     train.AddColumn("MHillas.GetArea");
     train.AddColumn("MNewImagePar.fLeakage1");
     train.AddColumn("MHillasExt.fM3Long*sign(MHillasSrc.fCosDeltaAlpha)");
     */

    // ------------------------------------------------------------

    // Last column must contain energy
    train.AddColumn("MMcEvt.fImpact/100");
    train.AddColumn("MMcEvt.fTelescopeTheta*kRad2Deg");
    train.AddColumn("MMcEvt.fEnergy");

    MStatusDisplay *d = new MStatusDisplay;

    // ----------------------- Fill Matrix RF ----------------------

    if(gRandom)
        delete gRandom;
    gRandom = new TRandom3();

    MTFillMatrix fill;
    fill.SetDisplay(d);
    fill.SetDestMatrix1(&train, 10000);//99999999);
    fill.SetReader(&read);

    if (!fill.Process())
        return;

    // ------------------------ Train RF --------------------------

    MRFEnergyEst rf;
    rf.SetDisplay(d);
    rf.SetFileName("rfenergys.root");

    MBinning b(32, 10, 100000, "BinningEnergyEst", "log");
    /*
    if (!rf.TrainMultiRF(train, b.GetEdgesD()))    // classification
        return;

    if (!rf.TrainSingleRF(train, b.GetEdgesD()))   // classification
        return;
    */
    if (!rf.TrainSingleRF(train))                  // regression
        return;


    gLog.Separator("Test");

    // --------------------- Display result ----------------------
    MParList  plist;
    MTaskList tlist;
    plist.AddToList(&tlist);
    plist.AddToList(&b);

    MHEnergyEst hist;
    MFillH fillh(&hist);

    tlist.AddToList(&read2);
    tlist.AddToList(&rf);
    tlist.AddToList(&fillh);

    MEvtLoop loop;
    loop.SetDisplay(d);
    loop.SetParList(&plist);

    if (!loop.Eventloop())
        return;

    //d->SaveAsPS("rfenergys.ps");
}
