#ifndef MARS_MJTrainSeparation
#define MARS_MJTrainSeparation

#ifndef MARS_MJTrainRanForest
#include "MJTrainRanForest.h"
#endif

#ifndef MARS_MDataSet
#include "MDataSet.h"
#endif

class MJTrainSeparation : public MJTrainRanForest
{
private:
    MDataSet fDataSetTest;
    MDataSet fDataSetTrain;

    UInt_t fNumTrainOn;
    UInt_t fNumTrainOff;

public:
    MJTrainSeparation() { }

    void SetDataSetTrain(const MDataSet &ds, UInt_t non, UInt_t noff)
    {
        ds.Copy(fDataSetTrain);
        fNumTrainOn = non;
        fNumTrainOff = noff;
    }
    void SetDataSetTest(const MDataSet &ds)
    {
        ds.Copy(fDataSetTest);
    }

    Bool_t Train(const char *out);

    ClassDef(MJTrainSeparation, 0)//Class to train Random Forest gamma-/background-separation
};

#endif
