#ifndef MARS_MRanForestCalc
#define MARS_MRanForestCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MDataArray;
class MParameterD;
class MHMatrix;

class MRanForestCalc : public MTask
{
public:
    enum EstimationMode_t
    {
        kMean,
        kMaximum,
        kFit
    };

private:
    static const TString gsDefName;     //! Default Name
    static const TString gsDefTitle;    //! Default Title
    static const TString gsNameOutput;  //! Default Output name

    Bool_t       fDebug;      // Debugging of eventloop while training on/off

    TString      fFileName;   // File name to forest
    TObjArray    fEForests;   // List of forests

    TString      fNameOutput; // Name of output container

    MDataArray  *fData;       //! Used to store the MDataChains to get the event values
    MParameterD *fRFOut;      //! Used to store result

    Int_t        fNumTrees;   //! Training parameters
    Int_t        fNumTry;     //! Training parameters
    Int_t        fNdSize;     //! Training parameters

    Int_t        fNumObsoleteVariables;

    MHMatrix    *fTestMatrix; //! Test Matrix used in Process (together with MMatrixLoop)

    EstimationMode_t fEstimationMode;

private:
    // MTask
    Int_t PreProcess(MParList *plist);
    Int_t Process();

    // MRanForestCalc
    Int_t ReadForests(MParList &plist);

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    // Train Interface
    Int_t Train(const MHMatrix &n, const TArrayD &grid, Int_t ver=2);

public:
    MRanForestCalc(const char *name=NULL, const char *title=NULL);
    ~MRanForestCalc();

    // Setter for estimation
    void SetFileName(TString filename)            { fFileName = filename; }
    void SetEstimationMode(EstimationMode_t op)   { fEstimationMode = op; }
    void SetNameOutput(TString name=gsNameOutput) { fNameOutput = name; }

    // Setter for training
    void SetNumTrees(UShort_t n=100) { fNumTrees = n; }
    void SetNdSize(UShort_t n=5)     { fNdSize   = n; }
    void SetNumTry(UShort_t n=0)     { fNumTry   = n; }
    void SetDebug(Bool_t b=kTRUE)    { fDebug    = b; }

    void SetNumObsoleteVariables(Int_t n=1) { fNumObsoleteVariables = n; }

    // Train Interface
    Int_t TrainMultiRF(const MHMatrix &n, const TArrayD &grid)
    {
        return Train(n, grid, 0);
    }
    Int_t TrainSingleRF(const MHMatrix &n, const TArrayD &grid=TArrayD())
    {
        return Train(n, grid, grid.GetSize()==0 ? 2 : 1);
    }

    // Test Interface
    void  SetTestMatrix(MHMatrix *m=0) { fTestMatrix=m; }
    void  InitMapping(MHMatrix *m=0)   { fTestMatrix=m; }

    ClassDef(MRanForestCalc, 0) // Task to calculate RF output and for RF training
};

#endif
