#ifndef MARS_MCameraTD
#define MARS_MCameraTD

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MCameraTD : public MParContainer, public MCamEvent
{
    friend class MReportCC;
private:
    TArrayS fTD; // [au] discriminator delays

public:
    MCameraTD(Int_t size=577, const char *name=NULL, const char *title=NULL);

    UShort_t operator[](Int_t i) { return (UShort_t)fTD[i]; }

    UShort_t GetMin() const;
    UShort_t GetMax() const;

    void Print(Option_t *opt=NULL) const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
        val = fTD[idx];
        return val>0;
    }
    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MCameraTD, 1) // Storage Container for Discriminator Delays
};

#endif
