/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 01/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// checkfileavail.C
// ================
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TEnv.h>

#include <MSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>

using namespace std;


TString GetStatus(MSQLServer &serv, TEnv &rc, TString primary, TString table, TString column)
{
    TString query(Form("SELECT %s FROM %s WHERE %s=%s",
                       column.Data(), table.Data(),
                       rc.GetValue(table+".Primary", ""),
                       primary.Data()));

    cout << "Query: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
    {
        cout << "Error - no run to check" << endl;
        return "";
    }

    TSQLRow *row=0;
    while ((row = res->Next()))
    {
//        TString entry=(*row)[0];
//        if (entry=="1970-01-01 00:00:00")
//            return "";
        return (*row)[0];
    }

    return "";
}

int checkfileavail(TString sequencefile)
{
    TEnv env("sql.rc");

    MSQLServer serv(env);
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "checkfileavail" << endl;
    cout << "--------------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    TEnv rc("steps.rc");

    TEnv sequ(sequencefile);

    TString runs;
    runs = sequ.GetValue("Runs", "");
    runs.ReplaceAll(" ", ",");
    if (runs.IsNull())
    {
        cout << "ERROR - No runs in file " << sequencefile << " found." << endl;
        return 0;
    }

    cout << "sequ file: " << sequencefile.Data() << endl;
    TString query(Form("SELECT fRunNumber FROM RunData WHERE fRunNumber in (%s)",
                       runs.Data()));

    TSQLResult *res = serv.Query(query);
    if (!res)
        cout << "Error - no run to check" << endl;

    TSQLRow *row=0;
    while ((row = res->Next()))
    {
        TString runno=(*row)[0];
        cout << "run#: " << runno << endl;
        if (GetStatus(serv, rc, runno, "RunProcessStatus", "fCCFileAvail")==""
            || GetStatus(serv, rc, runno, "RunProcessStatus", "fCaCoFileAvail")==""
            || GetStatus(serv, rc, runno, "RunProcessStatus", "fCaCoFileFound")==""
            || GetStatus(serv, rc, runno, "RunProcessStatus", "fTimingCorrection")==""
//            || GetStatus(serv, rc, runno, "RunProcessStatus", "fTimingCorrection")=="1970-01-01 00:00:00"
            || GetStatus(serv, rc, runno, "RunProcessStatus", "fRawFileAvail")=="")
            return 0;
    }
    return 1;

}

