/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 01/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// insertdate.C
// ============
//
// This macro is inserting a date into the table SequenceBuildStatus.
// It is executed by the script copyscript, which copies the slow control
// data to the appropriate directory and inserts the information into the
// database.
//
// Usage:
//  .x insertdate.C+("date")
//
// Make sure, that database and password are corretly set in a resource
// file called sql.rc and the resource file is found.
//
// Returns 0 in case of failure and 1 in case of success.
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TEnv.h>

#include <MSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>

using namespace std;

Bool_t ExistStr(MSQLServer &serv, const char *column, const char *table, const char *test)
{
    TString query(Form("SELECT %s FROM %s WHERE %s='%s'", column, table, column, test));

    cout << "query: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
        return kFALSE;

    Bool_t rc = kFALSE;

    TSQLRow *row=res->Next();
    if (row && (*row)[0])
        rc=kTRUE;

    delete res;
    return rc;
}


int insertdate(TString date)
{
    TEnv env("sql.rc");

    MSQLServer serv(env);
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "insertdate" << endl;
    cout << "----------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    //insert entry for date into the table SequenceBuildStatus,
    // if entry is not yet existing
    if (!ExistStr(serv, "fDate", "SequenceBuildStatus", date))
    {
        TString query(Form("INSERT SequenceBuildStatus SET fDate='%s', fCCFilled=Now() ",
                           date.Data()));

        TSQLResult *res = serv.Query(query);
        if (!res)
        {
            cout << "Error - could not insert entry" << endl;
            return 0;
        }
        delete res;
    }
    else
    {
        cout << date << " already exists... do update. " << endl;

        TString query="UPDATE SequenceBuildStatus SET fCCFilled=Now(), fExclusionsDone=NULL, ";
        query +=Form("fSequenceEntriesBuilt=NULL WHERE fDate='%s' ", date.Data());

        TSQLResult *res = serv.Query(query);
        if (!res)
        {
            cout << "Error - could not update entry" << endl;
            return 0;
        }
        delete res;
    }

    return 1;
}


