/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MCerPhotEvt.h"

#include <math.h>
#include <fstream.h>

#include <TCanvas.h>
#include <TClonesArray.h>

#include "MLog.h"
#include "MHexagon.h"
#include "MCerPhotPix.h"

ClassImp(MCerPhotEvt)

MCerPhotEvt::MCerPhotEvt(const char *name, const char *title) : fNumPixels(0)
{
  //   the default constructor 

  
  *fName  = name  ? name  : "MCerPhotEvt";
  *fTitle = name  ? name  : "(Number of Photon)-Event Information";
  
  fPixels = new TClonesArray ("MCerPhotPix", 577) ;

  //
  // FIXME: is this really necessary?
  //
  fPixels->Clear();
}

void MCerPhotEvt::Draw(Option_t* option) 
{
    //
    //   FIXME!!! Here the Draw function of the CamDisplay
    //   should be called to add the CamDisplay to the Pad.
    //   The drawing should be done in MCamDisplay::Paint
    //

    //    MGeomCam *geom = fType ? new MGeomCamMagic : new MGeomCamCT1;
    //    MCamDisplay *disp = new MCamDisplay(geom);
    //    delete geom;
    //    disp->DrawPhotNum(this);
}

void MCerPhotEvt::AddPixel(Int_t id, Float_t nph, Float_t err)
{
    //
    // add a new pixel to the list and increase the number
    // of valid pixels in the list by one
    //

    // TClonesArray -> 'operator new with placement' should be used
    new ((*fPixels)[fNumPixels++]) MCerPhotPix( id, nph, err);
}

void MCerPhotEvt::Clear(Option_t *)
{
    //
    // reset counter and delete netries in list.
    //
    fNumPixels = 0 ;
    fPixels->Clear() ;
}

void MCerPhotEvt::Print(Option_t *)
{
    const Int_t entries = fPixels->GetEntries();

    *fLog << "MCerPhotEvt::Print()" << endl
        << "Number of Pixels: " << fNumPixels
        << "(" << entries << ")"
        << endl ;

    for (Int_t il=0; il<entries; il++ )
        (*this)[il].Print();
}

Bool_t MCerPhotEvt::IsPixelExisting(Int_t id)
{
    //
    // Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++)
    {
        if (id == (*this)[il].GetPixId())
            return kTRUE ;
    }

    return kFALSE ;
} 

Bool_t MCerPhotEvt::IsPixelUsed(Int_t id)
{
    //
    //   Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++ )
    {
        MCerPhotPix &pix = (*this)[il];

        if (id == pix.GetPixId() && pix.IsPixelUsed())
            return kTRUE ;
    }

    return kFALSE ;
} 

Bool_t MCerPhotEvt::IsPixelCore(Int_t id)
{
    //
    //   Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++ )
    {
        MCerPhotPix &pix = (*this)[il];

        if ( id == pix.GetPixId() && pix.IsCorePixel())
            return kTRUE ;
    } 

    return kFALSE ;
} 

Float_t MCerPhotEvt::GetNumPhotonsMin()
{
    //
    // get the minimum number of photons of all valid pixels in the list
    //
    if (fNumPixels <= 0)
        return -5. ;

    Float_t minval = (*this)[0].GetNumPhotons();

    Float_t testval;
    for (UInt_t i=1 ; i<fNumPixels; i++ )
    {
        testval = (*this)[i].GetNumPhotons();

        if (testval < minval)
            minval = testval;
    }

    return minval;
}

Float_t MCerPhotEvt::GetNumPhotonsMax()
{
    //
    // get the maximum number of photons of all valid pixels in the list
    //
    if (fNumPixels <= 0)
        return 50.;

    Float_t maxval = (*this)[0].GetNumPhotons();

    Float_t testval;
    for (UInt_t i=1; i<fNumPixels; i++)
    {
        testval = (*this)[i].GetNumPhotons();

        if (testval > maxval)
            maxval = testval;
    }
    return maxval;
}

