/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MEvtDisp.h"

#include <TGButton.h>       // TGTextButton

#include "MGFadcDisp.h"

ClassImp(MEvtDisp)

enum {
  M_BUT_DISP1_EVT, 
  M_BUT_DISP1_PED, 
  M_BUT_DISP1_CAL, 
};

MEvtDisp::MEvtDisp(const TGWindow *main, const TGWindow *p,
                                 const UInt_t w, const UInt_t h)
: MBrowser(main, p, w, h)
{

    fButFadcDispEvts = new TGTextButton(fTop1, "FADC Disp for Events", M_BUT_DISP1_EVT );
    fButFadcDispEvts->Associate(this) ;
    fTop1->AddFrame (fButFadcDispEvts, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    fButFadcDispPed  = new TGTextButton(fTop1, "FADC Disp for PedEvts", M_BUT_DISP1_PED );
    fButFadcDispPed->Associate(this) ;
    fTop1->AddFrame (fButFadcDispPed, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    fButFadcDispCal  = new TGTextButton(fTop1, "FADC Disp for CalEvts", M_BUT_DISP1_CAL );
    fButFadcDispCal->Associate(this) ;
    fTop1->AddFrame (fButFadcDispCal, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

    MapSubwindows();

    Layout();

    SetWindowName("EventDispMain");
    SetIconName("EventDispMain");

    MapWindow();
} 

MEvtDisp::~MEvtDisp()
{
    delete fButFadcDispCal; 
    delete fButFadcDispPed; 
    delete fButFadcDispEvts;
} 

// ======================================================================

Bool_t MEvtDisp::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{     
    // Process events generated by the buttons in the frame.

    if (GET_MSG(msg) != kC_COMMAND || GET_SUBMSG(msg) != kCM_BUTTON)
        return MBrowser::ProcessMessage(msg, parm1, parm2);

    switch (parm1)
    {
    case M_BUT_DISP1_EVT:
    case M_BUT_DISP1_PED:
    case M_BUT_DISP1_CAL:
        if (!InputFileSelected())
        {        
            DisplError("No Input (root) File selected!");
            return kTRUE;
        }

        switch (parm1)
        {
        case M_BUT_DISP1_EVT:
            new MGFadcDisp(fInputFile, "Events",
                           fClient->GetRoot(), this, 600, 500);
            return kTRUE;

        case M_BUT_DISP1_PED:
            new MGFadcDisp( fInputFile , "PedEvts",
                            fClient->GetRoot(), this, 600, 500 ) ;
            return kTRUE;

        case M_BUT_DISP1_CAL:
            new MGFadcDisp( fInputFile , "CalEvts",
                            fClient->GetRoot(), this, 600, 500 ) ;
            return kTRUE;
        }
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
} 
