void getCollArea(char *filename = "/big0/Maggi/CamData/Gamma/gamma_15_on.root" ) 
{ 
    // FIXME: Harald, you should tell the people what the result of
    // this macro really is.

    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    //
    // Setup the parameter list.
    //  - we need to create MCollArea only. The other containers
    //    are created automatically without loss - we don't have to
    //    access them-
    //  - MCollArea must be created by us because we need the pointer
    //    to it and if it would get created automatically it would also be
    //    deleted automatically
    //
    parlist.AddToList(&tasklist);

    MCollArea *collArea = new MCollArea();
    parlist.AddToList(collArea);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadTree reader("Events", filename);
    tasklist.AddToList(&reader);

    MCollAreaTrigger effi;
    tasklist.AddToList(&effi);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    magic.Eventloop();

    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayd
    //
    collArea->Draw();
}
