<?php
{
    function CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs)
    {
        $fromtable="RunData";

        $groups = 0;
        foreach ($checkgroup as $element)
            if ($element==-1)
                $groups++;

        $statusgroups = 0;
        foreach ($checkstatusgroup as $element)
            if ($element==-1)
                $statusgroups++;

        $query0 = "SELECT ";

        if ($groups>0)
        {
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                    $query0 .=  $key . " as '" . $alias[$key] . "' " . ", ";
            //--------------------------------------------------
            //$query0 .= " TIMEDIFF(fRunStop, fRunStart), ";
            // Only available in MySQL>4.1.1
            $query0 .= "SUM(if(TIME_TO_SEC(fRunStop)-TIME_TO_SEC(fRunStart)<0, " .
                "TIME_TO_SEC(fRunStop)-TIME_TO_SEC(fRunStart)+24*60*60, " .
                "TIME_TO_SEC(fRunStop)-TIME_TO_SEC(fRunStart)))/3600 as '" . $alias["SUM(fRunTime)/3600"] . "', ";
            //--------------------------------------------------
            $query0 .= " SUM(fNumEvents) as '" . $alias["SUM(fNumEvents)"] . "', ";
            $query0 .= " Min(fZenithDistance) as '" . $alias["Min(fZenithDistance)"] . "', ";
            $query0 .= " Max(fZenithDistance) as '" . $alias["Max(fZenithDistance)"] . "', ";
            $query0 .= " COUNT(*) as 'Runs#' ";
        }
        else
        {
            if ($statusgroups>0)
            {
                foreach ($checkstatusgroup as $key => $element)
                    if ($element==-1)
                        $query0 .= " (if(IsNull(" . $key . "), if(isnull(fStartTime), 'not done', if(isnull(fFailedTime),if(isnull(" . $needs[$key] . "),'not done',if(date_sub(Now(),interval 12 hour) < fStartTime,'running','crashed')),if(isnull(" . $needs[$key] . "),'not done','failed'))) ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";
//                        $query0 .= " (if(IsNull(" . $key . "), 'not done' ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";

                $query0 .= " count(*) as 'Run#'";

            }
            else
            {
                $query0 .= " RunData.fRunNumber as 'Run#' ";

                foreach ($_GET as $key => $element)
                    if ($_GET[$key]=="On" && $key!="fTest")
                        if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                            $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";
            }
        }

        $query0 .= " FROM RunData ";

        $query0 .= " LEFT JOIN RunProcessStatus ON RunData.fRunNumber=RunProcessStatus.fRunNumber ";

        foreach ($_GET as $key => $element)
            if (($_GET[$key]=="On" || $groups>0))// && !empty($joins[$key]))
                $query0 .= GetJoin($fromtable,$key);

        if ($_GET["fTest"]!="On")
        {
            if ($_GET["fSource"]!="On")
                $query0 .= " LEFT JOIN Source ON Sequences.fSourceKEY=Source.fSourceKEY ";
            $query0 .= " WHERE fTest='no'";
        }

        foreach ($checkwhere as $key => $element)
        {
            if (empty($element) || $element<=0)
                continue;

            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                if ($element!=-1)
                    if (strrpos($query0, " AND ")!=strlen($query0)-5)// this if clause doesn't work
                        $query0 .= " AND ";

            if ($element!=-1)
                $query0 .= GetCheck($fromtable, $key) . "=" . $element;
        }

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= StatusQuery("fCCFileAvail", $needs);
        $query0 .= StatusQuery("fCaCoFileAvail", $needs);
        $query0 .= StatusQuery("fCaCoFileFound", $needs);
        $query0 .= StatusQuery("fRawFileAvail", $needs);
        $query0 .= StatusQuery("fDataCheckDone", $needs);
        $query0 .= StatusQuery("fTimingCorrection", $needs);

        if (!empty($_GET["fRunMin"]) && !empty($_GET["fRunMax"]))
            $query0 .= "RunData.fRunNumber BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";

/*
        if (!empty($_GET["fDate"]))
            $query0 .= " AND fRunStart REGEXP \"^" . $_GET["fDate"] . "\" ";
*/

        if (!empty($_GET["fSourceN"]))
            $query0 .= " AND fSourceName REGEXP \"^" . $_GET["fSourceN"] . "\" ";

        if (!empty($_GET["fStartDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0)
                $query0 .= " AND ";

            $startdate=substr($_GET["fStartDate"], 0, 10);
            if ($startdate=="0000-00-00")
                $query0 .=" fRunStart >= '" . $startdate . " 00:00:00' ";
            else
                $query0 .= " fRunStart >= ADDDATE('" . $startdate . " 13:00:00', INTERVAL -1 DAY) ";
        }

        if (!empty($_GET["fStopDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0)
                $query0 .= " AND ";

            $stopdate=substr($_GET["fStopDate"], 0, 10);
            $query0 .= " fRunStart < '" . $stopdate . " 13:00:00' ";
        }

        if (!empty($_GET["fSequenceNo"]) || $_GET["fSequenceNo"]=="0")
        {
            if (strpos(strrev($query0), " DNA ")!=0)
                $query0 .= " AND ";

            $query0 .= " fSequenceFirst = '" . $_GET["fSequenceNo"] . "' ";
        }


        if ($groups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $groups;
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= GetCheck($fromtable,$key);
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if ($statusgroups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $statusgroups;
            foreach ($checkstatusgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= $alias[$key];
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if (!empty($_GET["fSortBy"]))
        {
            $val=substr($_GET["fSortBy"], 0, -1);
            $query0 .= " ORDER BY " . GetTable($fromtable, $val) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        if (empty($_GET["fSendTxt"]))
            $query0 .= " LIMIT " . $_GET["fNumStart"] . ", " . $_GET["fNumResults"];

        return $query0;
    }

    function InitGet($_GET)
    {
        /*
         if (empty($_GET["fRawFileKEY"]))
         $_GET["fRawFileKEY"]="Off";
         */

        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fNumResults"]))
            $_GET["fNumResults"]="20";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fTest"]))
            $_GET["fTest"]=$first?"On":"";

        if (empty($_GET["fFormatVersion"]))
            $_GET["fFormatVersion"]="Off";

        if (empty($_GET["fNumEvents"]))
            $_GET["fNumEvents"]=$first?"On":"";

        if (empty($_GET["fRunStart"]))
            $_GET["fRunStart"]=$first?"On":"";

        if (empty($_GET["fRunStop"]))
            $_GET["fRunStop"]="Off";

        if (empty($_GET["fAzimuth"]))
            $_GET["fAzimuth"]="Off";

        if (empty($_GET["fZenithDistance"]))
            $_GET["fZenithDistance"]=$first?"On":"";

        if (empty($_GET["fRunTypeName"]))
            $_GET["fRunTypeName"]=$first?"On":"";

        if (empty($_GET["fMagicNumberName"]))
            $_GET["fMagicNumberName"]="Off";

        if (empty($_GET["fSourceName"]))
            $_GET["fSourceName"]=$first?"On":"";

        if (empty($_GET["fProjectName"]))
            $_GET["fProjectName"]="Off";

        if (empty($_GET["fL1TriggerTableName"]))
            $_GET["fL1TriggerTableName"]="Off";

        if (empty($_GET["fL2TriggerTableName"]))
            $_GET["fL2TriggerTableName"]="Off";

        if (empty($_GET["fMeanTriggerRate"]))
            $_GET["fMeanTriggerRate"]=$first?"On":"";

        if (empty($_GET["fHvSettingsName"]))
            $_GET["fHvSettingsName"]="Off";

        if (empty($_GET["fCalibrationScriptName"]))
            $_GET["fCalibrationScriptName"]="Off";

        if (empty($_GET["fDiscriminatorThresholdTableName"]))
            $_GET["fDiscriminatorThresholdTableName"]="Off";

        if (empty($_GET["fTriggerDelayTableName"]))
            $_GET["fTriggerDelayTableName"]="Off";

        if (empty($_GET["fLightConditionsName"]))
            $_GET["fLightConditionsName"]="Off";

        if (empty($_GET["fTestFlagName"]))
            $_GET["fTestFlagName"]="Off";

        if (empty($_GET["fDaqStoreRate"]))
            $_GET["fDaqStoreRate"]="Off";

        if (empty($_GET["fDaqTriggerRate"]))
            $_GET["fDaqTriggerRate"]="Off";

        if (empty($_GET["fL2RatePresc"]))
            $_GET["fL2RatePresc"]="Off";

        if (empty($_GET["fL2RateUnpresc"]))
            $_GET["fL2RateUnpresc"]="Off";

        if (empty($_GET["fExcludedFDAName"]))
            $_GET["fExcludedFDAName"]=$first?"On":"";

        if (empty($_GET["fSequenceFirst"]))
            $_GET["fSequenceFirst"]="Off";

        if (empty($_GET["fSequenceNo"]))
            $_GET["fSequenceNo"]="";

        if (empty($_GET["fDataCheckDone"]))
            $_GET["fDataCheckDone"]="Off";

        if (empty($_GET["fDataCheckDoneStatus"]))
            $_GET["fDataCheckDoneStatus"]="0";

        if (empty($_GET["fCCFileAvail"]))
            $_GET["fCCFileAvail"]=$first?"On":"";

        if (empty($_GET["fCCFileAvailStatus"]))
            $_GET["fCCFileAvailStatus"]="0";

        if (empty($_GET["fCaCoFileAvail"]))
            $_GET["fCaCoFileAvail"]=$first?"On":"";

        if (empty($_GET["fCaCoFileAvailStatus"]))
            $_GET["fCaCoFileAvailStatus"]="0";

        if (empty($_GET["fCaCoFileFound"]))
            $_GET["fCaCoFileFound"]="Off";

        if (empty($_GET["fCaCoFileFoundStatus"]))
            $_GET["fCaCoFileFoundStatus"]="0";

        if (empty($_GET["fRawFileAvail"]))
            $_GET["fRawFileAvail"]=$first?"On":"";

        if (empty($_GET["fRawFileAvailStatus"]))
            $_GET["fRawFileAvailStatus"]="0";

        if (empty($_GET["fTimingCorrection"]))
            $_GET["fTimingCorrection"]=$first?"On":"";

        if (empty($_GET["fTimingCorrectionStatus"]))
            $_GET["fTimingCorrectionStatus"]="0";

    }

    function PrintForm($_GET, $host, $user, $pw, $db)
    {
        printf("<center>\n");
        printf("<form action=\"runinfo.php\" METHOD=\"GET\">\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fRunStart",         "Run start time");
        CheckBox("fL2RatePresc",      "L2 presc Rate");
        CheckBox("fDaqStoreRate",     "DAQ Storage Rate");
        CheckBox("fAzimuth",          "Azimuth");

        printf("  </tr><tr>\n");

        CheckBox("fRunStop",          "Run stop time");
        CheckBox("fL2RateUnpresc",    "L2 unpresc Rate");
        CheckBox("fDaqTriggerRate",   "DAQ Trigger Rate");
        CheckBox("fZenithDistance",   "Zenith distance");

        printf("  </tr><tr>\n");

//        CheckBox("fFormatVersion",    "File format");
        CheckBox("fNumEvents",        "Num of events");
        CheckBox("fMeanTriggerRate",  "Mean Trigger rate");
        CheckBox("fSequenceFirst",    "Sequence Number");
        CheckBox("fTest",             "incl. TestSources");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <table>\n");
        printf("  <tr><td>\n");

        PrintStatusMenu("fCCFileAvail",    "CC File available");
        printf("  </td><td>\n");
        PrintStatusMenu("fCaCoFileAvail",  "Caco File available");
        printf("  </td><td>\n");
        PrintStatusMenu("fRawFileAvail",   "Rawfile available");

        printf("  </td></tr><tr><td>\n");

        PrintStatusMenu("fTimingCorrection",  "Timing Correction");
        printf("  </td><td>\n");
        PrintStatusMenu("fCaCoFileFound",     "Caco File");
        printf("  </td><td>\n");
        PrintStatusMenu("fDataCheckDone",        "DataCheck");

        printf(" </td></tr></table>\n");
        printf(" <p>\n");

        // pull down boxes

        printf(" <table>\n");
        printf("  <tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "RunType",     "fRunTypeName",     "fRunTypeKEY", "Run type");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "Source",      "fSourceName",      "fSourceKEY", "Source Name");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "HvSettings",  "fHvSettingsName",  "fHvSettingsKEY", "HV Settings");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "L1TriggerTable", "fL1TriggerTableName", "fL1TriggerTableKEY", "L1 Trigger Table");
        printf("  </td></tr><tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "TestFlag",  "fTestFlagName",  "fTestFlagKEY", "Test Flag");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "Project",     "fProjectName",     "fProjectKEY", "Project Name");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "DiscriminatorThresholdTable",  "fDiscriminatorThresholdTableName",  "fDiscriminatorThresholdTableKEY", "DT Table");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "L2TriggerTable", "fL2TriggerTableName", "fL2TriggerTableKEY", "L2 Trigger Table");
        printf("  </td></tr><tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "ExcludedFDA", "fExcludedFDAName", "fExcludedFDAKEY", "Exclusions");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "LightConditions",  "fLightConditionsName",  "fLightConditionsKEY", "Light Conditions");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "CalibrationScript",  "fCalibrationScriptName",  "fCalibrationScriptKEY", "Cal Script");
        printf("  </td><td>\n");
        PrintPullDown($host, $user, $pw, $db, "TriggerDelayTable",  "fTriggerDelayTableName",  "fTriggerDelayTableKEY", "Trigger Delay Table");
        printf("  </td></tr><tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "MagicNumber", "fMagicNumberName", "fMagicNumberKEY", "Magic Number");
        printf(" </td></tr></table>\n");

        printf(" <p>\n");

        if (empty($_GET["fStartDate"]))
            $timemin = GetMin("fRunStart", "RunData", $host, $user, $pw, $db);
        else
            $timemin = $_GET["fStartDate"];

        if (empty($_GET["fStopDate"]))
            $timemax = GetMax("fRunStart", "RunData", $host, $user, $pw, $db);
        else
            $timemax = $_GET["fStopDate"];

        printf("Sequ#&nbsp;<input name=\"fSequenceNo\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"");
        if (!empty($_GET["fSequenceNo"]))
            printf("%s", $_GET["fSequenceNo"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");

        printf("Night&nbsp;(yyyy-mm-dd)&nbsp;from&nbsp;<input name=\"fStartDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">\n", $timemin);
        printf("to&nbsp;<input name=\"fStopDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">&nbsp;&nbsp;&nbsp;&nbsp;\n", $timemax);

/*
        printf("Date&nbsp;(yyyy-mm-dd)&nbsp;<input name=\"fDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"");
        if (!empty($_GET["fDate"]))
            printf("%s", $_GET["fDate"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");
*/

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fRunNumber", "RunData", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fRunNumber", "RunData", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];

        printf("Runs&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf("Source&nbsp;(<A HREF=\"regexp.html\">regexp</A>)&nbsp;<input name=\"fSourceN\" type=\"text\" size=\"15\" maxlength=\"15\" value=\"");
        if (!empty($_GET["fSourceN"]))
            printf("%s", $_GET["fSourceN"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");

        printf(" Results:\n");
        printf(" <select name=\"fNumResults\">\n");

        $numres = array("10", "20", "50", "100", "200", "500", "1000", "2000");
        foreach ($numres as $element)
        {
            if ($element==$_GET["fNumResults"])
                printf("<option value=\"%s\" selected>%3s</option>\n", $element, $element);
            else
                printf("<option value=\"%s\">%3s</option>\n", $element, $element);
        }
        printf(" </select>\n");
        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"runinfo.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Print' onClick='self.location.href=\"%s&fPrintTable=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");
        printf("</td>\n");
        printf("</tr>\n");
        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);
        mysql_query("SET BIG_TABLES=1"); // necessary for mySQL <= 4

        $query0 = CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs);

        $result0 = mysql_query($query0, $db_id);

        if ($result0)
        {
            if ($html=="1" || $html=="2")
                PrintMagicTable($result0, $alias, $rightalign, "", "", $_GET);
            else
                PrintText($result0);

            mysql_free_result($result0);
        }
        mysql_close($db_id);

        if ($html=="1")
            printf("<U><B>submitted query:</B></U><BR>%s<BR>", htmlspecialchars($query0));
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors",   "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        if (empty($_GET["fPrintTable"]))
            PrintForm($_GET, $host, $user, $pw, $db);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
        {
            if (empty($_GET["fPrintTable"]))
                PrintPage("1", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs);
            else
                PrintPage("2", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs);
        }

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors",   "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
