#ifndef MARS_MHSrcPosCam
#define MARS_MHSrcPosCam

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

#ifndef ROOT_TVector2
#include <TVector2.h>
#endif

class MParList;
class MParameterD;
class MPointingPos;

class MHSrcPosCam : public MH
{
private:
    TH2D          fHist;           //

private:
    MTime         fTimeLastEffOn;  //!
    MTime        *fTimeEffOn;      //!
    MParameterD  *fEffOnTime;      //!
    MPointingPos *fSourcePos;      //!

    TVector2      fXY;             //!
    UInt_t        fNum;            //!
    Double_t      fConvMm2Deg;     //!

public:
    MHSrcPosCam(const char *name=NULL, const char *title=NULL);

    // MH
    Bool_t SetupFill(const MParList *pl);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    // MHSrcPosCam
    const TH2D &GetHist() const { return fHist; }

    // TObject
    void Draw(Option_t *option="");

    ClassDef(MHSrcPosCam, 1) // Histogram for source position distribution
};

#endif
