/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

////////////////////////////////////////////////////////////////////////
//
//  MFillHHillas
//
//  This task fills the hillas parameter from MHillas into
//  histograms (MHHillas)
//
////////////////////////////////////////////////////////////////////////
#include "MFillHHillas.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MHHillas.h"
#include "MParList.h"

ClassImp(MFillHHillas)

// --------------------------------------------------------------------------
MFillHHillas::MFillHHillas (const char *name, const char *title)
{
    *fName  = name  ? name  : "MFillHHillas";
    *fTitle = title ? title : "Task to fill Hillas histograms";
}

// --------------------------------------------------------------------------
Bool_t MFillHHillas::PreProcess (MParList *pList)
{
    fEvt = (MHillas*)pList->FindObject("MHillas");
    if (!fEvt)
    {
        *fLog << dbginf << "MHillas not found... aborting." << endl;
        return kFALSE ;
    }

    fHistos = (MHHillas*)pList->FindCreateObj("MHHillas");
    if (!fHistos)
        return kFALSE;

    return kTRUE ;
} 

// --------------------------------------------------------------------------
Bool_t MFillHHillas::Process()
{
    fHistos->Fill(fEvt);

    return kTRUE;
} 
