#!/usr/bin/python
##############################################################
#
#  CommunicateWithVME.py
#  Handles the communication with the VME crate
#  can send commands to the VME crate
#
#  
#  Michael Rissi 05/2009
#
#############################################################

import GlobalVariables
import threading
import _VME
import time
def GetRate(module,channel):
    _VME.V560_Clear_Scales( module)
    beginCounter=_VME. V560_Read_Counter( module,  channel)
    GlobalVariables.ServerMessage = "Evaluating rates (2 seconds)..."
    time.sleep(2)
    endCounter = _VME. V560_Read_Counter( module,  channel)
    return (endCounter-beginCounter)/2000.

def GetRates(module):
    _VME.V560_Clear_Scales( module)
    beginCounter =[0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    endCounter =  [0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    rates      =  ["rates",
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    
    for i in range(0,16):
        beginCounter[i]=_VME. V560_Read_Counter( module,  i)
        #GlobalVariables.ServerMessage = str(beginCounter[i])
    #GlobalVariables.ServerMessage = "Evaluating rates..."
    time.sleep(2)
    for i in range(0,16):
        endCounter[i] = _VME. V560_Read_Counter( module,  i)
        #GlobalVariables.ServerMessage = str(endCounter[i])
        rates[i+1] =(endCounter[i]-beginCounter[i])/2000.
    return rates

class GimmeRates(threading.Thread):
    rates=["rates",
        0,0,0,0,
           0,0,0,0,
           0,0,0,0,
           0,0,0,0]
    module = 1
    def run(self):
        oldcommand=GlobalVariables.UserInput
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            time.sleep(0.001)
            newrates = GetRates(self.module)
            self.rates=newrates

class ParseUserInput(threading.Thread):
    gimmeRates=GimmeRates()
    def Parse(self,Command):
        Command = Command[1:]
        #GlobalVariables.ServerMessage = "PARSING: " + Command
        sCommand=Command.split()
        error_code=0
        #python lacks switch...
        try:
            VMEModule=sCommand[0]
            if(VMEModule == "help"):
                GlobalVariables.ServerMessage = "please use \'<V812|V560|Triggerboard> help\' "
                #GlobalVariables.ServerMessage="please use \'<V812|V560|Triggerboard> help\' "
            
            # now do the stuff for the V560:
            if(VMEModule == "V560"):
                V560Command=sCommand[1]
                if(V560Command=="help"):
                    GlobalVariables.ServerMessage = "available functions are: \n"
                    GlobalVariables.ServerMessage += "V560 GetRate <module#> <channel#>\n"
                    GlobalVariables.ServerMessage += "V560 GetRates <module#\n "
                    time.sleep(0.05)
                    
                if(V560Command=="GetRate"):
                    #GlobalVariables.ServerMessage = "trying to get rate"
                    #time.sleep(0.05)
                    

                    try:
                        module = int(sCommand[2])
                        channel= int(sCommand[3])
                        if(module!= self.gimmeRates.module):
                            self.gimmeRates.module=module
                            GlobalVariables.ServerMessage = "please wait... (5sec)"
                            time.sleep(5)
                        
                        GlobalVariables.ServerMessage = str(self.gimmeRates.rates[channel])
                        time.sleep(0.01)
                    except:
                        GlobalVariables.ServerMessage = "Syntax Error (GetRate)"
                        time.sleep(0.01)
                    #GlobalVariables.Rates[int(channel)] = GetRates(int(module),int(channel))

                if(V560Command=="GetRates" or V560Command=="GR"):
                    GlobalVariables.ServerMessage = "trying to get rates"
                    time.sleep(0.01)
                    try:
                        module = int(sCommand[2])
                        if(module!= self.gimmeRates.module):
                            self.gimmeRates.module=module
                            GlobalVariables.ServerMessage = "please wait... (5sec)"
                            time.sleep(5)
                        #GlobalVariables.ServerMessage = "RATES:"
                        GlobalVariables.ServerMessage = str(self.gimmeRates.rates)
                        time.sleep(0.01)
                    except:
                        GlobalVariables.ServerMessage = "Syntax Error (GetRates)"
                        time.sleep(0.05)
                    #GlobalVariables.Rates[int(channel)] = GetRates(int(module),int(channel))
        

            # now do the stuff for the V812:
            elif(VMEModule == "V812"):
                V812Command=sCommand[1]
                if(V812Command=="help"):
                    GlobalVariables.ServerMessage  = "available functions are: \n"
                    GlobalVariables.ServerMessage += "V812 SetHexPat <module#[1-10]> <HexPattern[0x0000-0xFFFF>\n"
                    GlobalVariables.ServerMessage += "V812 SetThresh <module#[1-10]> <channel#[0-15]> <thresh[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetAllThresh <module#[1-10]>  <thresh[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetMajLevel <module#[1-10]> <MajLev[1-20]>\n"
                    GlobalVariables.ServerMessage += "V812 SetMajThresh <module#[1-10]> <MajThr[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetDeadTime <module#[1-10]> <Block [0-1]> <DeadTime[0-255]>\n"
                    time.sleep(0.05)
                #set the hexpattern:
                elif(V812Command=="SetHexPat"):
                    GlobalVariables.ServerMessage = "trying to set the hexpattern:"
                    time.sleep(0.05)
                    try:
                        module = int(sCommand[2])
                        hexpat = int(sCommand[3],16)
                        #print hexpat
                        # hexpat="ddd"
                        GlobalVariables.ServerMessage = "setting module "+str(module)+" to hexpat: "+str(hex(hexpat))
                        time.sleep(0.05)
                        try:
                            print "setting it now..."
                            error_code=_VME.V812_Set_Pattern_Inhibit_Hex(module, hexpat)
                            GlobalVariables.ServerMessage = "success! "
                            time.sleep(0.05)
                            
                        except:
                            VME_ErrorPrint(error_code)
                            print "FAILED"
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetHexPat)"

                        
                        time.sleep(0.05)
                elif(V812Command=="SetAllThresh"):
                    print "trying to set all the threshold:"
                    try:
                        module  = int(sCommand[2])
                        thresh  = int(sCommand[3])
                        GlobalVariables.ServerMessage="Setting all thresholds...\n"
                        for channel in range(0,16):
                            GlobalVariables.ServerMessage += "setting threshold of channel: "+str(channel)+ " in module "+str(module)+" to: "+str(thresh)+"\n"
                            GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel,  thresh))+"\n"
                        time.sleep(0.05)
                            
                            
                    except:
                        print "Syntax error (SetAllThresh) "
                elif(V812Command=="SetThresh"):
                    GlobalVariables.ServerMessage = "trying to set the threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        channel = int(sCommand[3])
                        thresh  = int(sCommand[4])
                        GlobalVariables.ServerMessage = "setting threshold of channel: "+str(channel)+ " in module "+str(module)+" to: "+str(thresh)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel,  thresh))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetThresh) "
                        time.sleep(0.05)
                elif(V812Command=="SetMajLevel"):
                    GlobalVariables.ServerMessage = "trying to set the majority level:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        level   = int(sCommand[3])
                        GlobalVariables.ServerMessage = "setting maj. level of module "+str(module)+" to: "+str(level)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Majority_Level(module,level))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetMajLevel)"
                        time.sleep(0.05)

                elif(V812Command=="SetMajThresh"):
                    GlobalVariables.ServerMessage = "trying to set the majority threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        thresh  = int(sCommand[3])
                        GlobalVariables.ServerMessage = "setting maj. level of module "+str(module)+" to: "+str(thresh)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Majority_Threshold(module,  thresh))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetMajThresh)"
                        time.sleep(0.05)

                elif(V812Command=="SetDeadTime"):
                    GlobalVariables.ServerMessage = "trying to set the majority threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        block  = int(sCommand[3])
                        deadtime= int(sCommand[4])
                        GlobalVariables.ServerMessage = "setting deadtime of module "+str(module)+" block: "+str(block)+ " to: "+str(deadtime)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Dead_Time(module, block, deadtime))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetMajThresh)"
                        time.sleep(0.05)

                else:
                    GlobalVariables.ServerMessage = "Syntax Error (V812)"
                    time.sleep(0.05)
                        
        except:
            GlobalVariables.ServerMessage = "syntax error"
            time.sleep(0.05)
        #_VME.V812_Set_Threshold(1, 0,  255)
    
    def __init__(self):
        threading.Thread.__init__(self)
    def run(self):
        self.gimmeRates.start()
        oldcommand=GlobalVariables.UserInput
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            CommandToParse=GlobalVariables.UserInput
            if(oldcommand!=CommandToParse):
                self.Parse(CommandToParse)
                oldcommand=CommandToParse
            time.sleep(0.05)


            
        GlobalVariables.ServerMessage = "EXITING PARSER...press <enter> to exit"
        time.sleep(0.05)
            
