/********************************************/
/*Header file for the CAEN V812             */
/*16 Channel constant fraction discriminator*/
/*                                          */
/*Author: Thomas Kraehenbuehl               */
/* adapted by Michael Rissi to be wrapped by*/
/* Python                                   */
/*Date: 27 February 2008                    */
/*Based on v792.h by Markus Joos            */
/********************************************/

#ifndef _V812_H
#define _V812_H

//******************************************************************************
//Constants
//******************************************************************************

#define V812_CHANNELS 16
#include "rcc_error/rcc_error.h"
#include "vme_rcc/vme_rcc.h"
//******************************************************************************
//Type definitions
//******************************************************************************

//This struct maps the memory of a v812 module.
typedef struct {
//	Variable name							//Adress offset		//Read-/Write-Mode
	u_short threshold_ch[V812_CHANNELS];	//0x00-0x1E			//w
	u_short dummy1[16];						//0x20-0x3E			//none
	u_short output_width[2];				//0x40-0x42			//w
	u_short dead_time[2];					//0x44-0x46			//w
	u_short majority_threshold;				//0x48				//w
	u_short pattern_inhibit;				//0x4A				//w
	u_short test_pulse;						//0x4C				//w
	u_short dummy2[86];						//0x4E-0xF8			//none
	u_short fixed_code;						//0xFA				//r
	u_short manufacturer_type;				//0xFC				//r
	u_short version_serialnumber;			//0xFE				//r
} v812_registers_t;

//This struct contains the information necessary to handle one module
typedef struct {
	v812_registers_t* registers;		//contains the virtual address of the module
	int master_mapping;					//contains the handle of the module
	char present;						//0 if module not present, 1 if present
} v812_module_t;

//******************************************************************************
//Global Variables
//******************************************************************************

v812_module_t v812_modules[]; //TODO: not sure if this is correct

//******************************************************************************
//Function Definitions
//******************************************************************************

VME_ErrorCode_t V812_Open(void);
int V812_Set_Threshold(short module, short channel, short threshold);
int V812_Set_Pattern_Inhibit(short module, char channel[16]);
int V812_Set_Output_Width(short module, char channel_block, short width);
int V812_Set_Dead_Time(short module, short channel_block, short dead_time);
int V812_Set_Majority_Level(short module, short majority_level);
int V812_Set_Majority_Threshold(short module, short majority_threshold);
int V812_Test_Pulse(short module);
int V812_Print_Info(void);
int V812_Set_Pattern_Inhibit_Hex(short module, int pattern);
VME_ErrorCode_t V812_Close(void);

//******************************************************************************

#endif
