#ifndef MARS_MFHadAlpha
#define MARS_MFHadAlpha

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

#ifndef ROOT_TString
#include "TString.h"
#endif

class MParList;
class MHadAlphaCut;
class MHadronness;
class MHillas;
class MHillasSrc;
class MPointingPos;
class MEnergyEst;

class MFHadAlpha : public MFilter
{

 public:

   typedef enum { kHadCut, kAlphaCut, kHadAlphaCut } FilterType_t;
    FilterType_t fFilterType;

 private:
   
    MHadronness*  fHadronness;
    MHillas*      fHillas; 
    MHillasSrc*   fHillasSrc;
    MHadAlphaCut* fHadAlphaCut;
    MPointingPos* fPointingPos;
    MEnergyEst*   fEnergyEst;

    TString fFileName;

    Bool_t  fResult; //!

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:

    MFHadAlpha( const char *name=NULL, const char *title=NULL);
  
    Bool_t IsExpressionTrue() const { return fResult; }

    void SetInputCutsFile(const char* fname) { fFileName = fname; }

    void SetCutType(FilterType_t type) { fFilterType = type; }

    ClassDef(MFHadAlpha, 1) // A Filter for cuts in fabs(alpha)
};

#endif
