#ifndef MARS_MHThetaSqN
#define MARS_MHThetaSqN

#ifndef MARS_MHAlpha
#include "MHAlpha.h"
#endif

class TVector2;

class MTaskList;
class MSrcPosCam;

class MHThetaSqN : public MHAlpha
{
private:
    MParameterD *fDisp;      //!
    MSrcPosCam  *fSrcPosCam; //!

    Double_t fMm2Deg;

    UInt_t fNumBinsSignal;
    UInt_t fNumBinsTotal;
    UInt_t fNumOffSourcePos;

    Bool_t fDoOffCut;

    // MHThetaSqN
    TVector2 GetVec(const TVector2 &v, Int_t n1) const;
    void     SetVal(Double_t val);

    // MHAlpha
    Bool_t   GetParameter(const MParList &pl) { return kTRUE; }
    Double_t GetVal() const;

    // MH
    Bool_t   SetupFill(const MParList *pl);
    Bool_t   Fill(const MParContainer *par, const Stat_t weight);

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);

public:
    MHThetaSqN(const char *name=NULL, const char *title=NULL);
    ~MHThetaSqN();

    void InitMapping(MHMatrix *mat, Int_t type=0);

    void SetNumBinsSignal(UInt_t n)      { fNumBinsSignal  =TMath::Max(n, 1U); }
    void SetNumBinsTotal(UInt_t n)       { fNumBinsTotal   =TMath::Max(n, 1U); }
    void SetNumOffSourcePos(UInt_t n=3)  { fNumOffSourcePos=TMath::Max(n, 1U); }

    void SetDoOffCut(Bool_t b=kTRUE)     { fDoOffCut = b; }

    ClassDef(MHThetaSqN, 1) // Theta-Plot which is fitted online
};

#endif
