import threading
import GlobalVariables
import serial
import time
import datetime
class ListenToArduino(threading.Thread):
    ser = serial.Serial('/dev/myArduino', 9600)
    year = datetime.date.today().year
    month = datetime.date.today().month
    day = datetime.date.today().day
    date=str(year)
    date+="0"
    date+=str(month)
    date+=str(day)
    filename="Arduino_testing_"+date+".txt"
    fileHandle = open ( filename, 'w' )
    fileHandle.close()
    
    def run(self):
        time.sleep(0.01)
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            ArduinoMessage = self.ser.readline()
            GlobalVariables.ServerMessage   = ArduinoMessage
            #GlobalVariables.ServerMessage   = "[Temp ,28,10]"
            time.sleep(0.05)

            self.fileHandle = open ( self.filename, 'a' ) 
            t = datetime.datetime.now()
            EpochSeconds=time.mktime(t.timetuple())
            now = datetime.datetime.fromtimestamp(EpochSeconds)
            
            if ArduinoMessage[0]=='[':
                self.fileHandle.write(now.ctime())
                self.fileHandle.write(" ")
                self.fileHandle.write(str(EpochSeconds))
                self.fileHandle.write(" ")
                self.fileHandle.write(ArduinoMessage)
            self.fileHandle.close()

