#include <QApplication>
#include <QFont>
#include <QGridLayout>

#include <QPushButton>

#include "main.h"
#include <QThread>
#include <QTimer>
#include <time.h>



void sleep_now(unsigned int mseconds)
{
  printf("in  %i\n",clock());
  clock_t goal = mseconds + clock();

  while (goal > clock());
  printf("out %i\n",goal);
}



 MyWidget::MyWidget(QWidget *parent)
     : QWidget(parent)
 {
   //PixelToTriggerPixel=new int[16];
   

   PixelToTriggerPixel=new int[16];
   /* PixelToTriggerPixel[0]= 25;
   PixelToTriggerPixel[1]= 26;
   PixelToTriggerPixel[2]= 27;
   PixelToTriggerPixel[3]= 28;
   PixelToTriggerPixel[4]= 19;
   PixelToTriggerPixel[5]= 20;
   PixelToTriggerPixel[6]= 21;
   PixelToTriggerPixel[7]= 22;
   PixelToTriggerPixel[8]= 13;
   PixelToTriggerPixel[9]= 14;
   PixelToTriggerPixel[10]= 15;
   PixelToTriggerPixel[11]= 16;
   PixelToTriggerPixel[12]= 7;
   PixelToTriggerPixel[13]= 8;
   PixelToTriggerPixel[14]= 9;
   PixelToTriggerPixel[15]= 10;*/
   
   PixelToTriggerPixel[0]= 25;
   PixelToTriggerPixel[1]= 26;
   PixelToTriggerPixel[2]= 27;
   PixelToTriggerPixel[3]= 28;
   PixelToTriggerPixel[4]= 19;
   PixelToTriggerPixel[5]= 20;
   PixelToTriggerPixel[6]= 21;
   PixelToTriggerPixel[7]= 22;
   PixelToTriggerPixel[8]= 13;
   PixelToTriggerPixel[9]= 14;
   PixelToTriggerPixel[10]= 15;
   PixelToTriggerPixel[11]= 16;
   PixelToTriggerPixel[12]= 7;
   PixelToTriggerPixel[13]= 8;
   PixelToTriggerPixel[14]= 9;
   PixelToTriggerPixel[15]= 10;
   ListToTemperaturePixel = new int[7];
   ListToTemperaturePixel[0] = 5;
   ListToTemperaturePixel[1] = 1;
   ListToTemperaturePixel[2] = 0;
   ListToTemperaturePixel[3] = 2;
   ListToTemperaturePixel[4] = 3;
   ListToTemperaturePixel[5] = 4;
   ListToTemperaturePixel[6] = 6;
    SocketWindow = new QWidget();
   SocketWindow->setWindowTitle("trigger - Socket Interface");
   Socket = new QTcpSocket(SocketWindow);
   connect(Socket, SIGNAL(readyRead()), this, SLOT(ReadFromSocket()));
   //connect(Socket, SIGNAL(disconnected()), this, SLOT(GotDisconnected()));
   WaitForData=false;
   ManualDisconnect=false;
  
   IPAddress = new QLineEdit(SocketWindow);
   IPAddress->setText("eth-vme02");
   IPAddress->setToolTip("Address of socket server");
   AddressLayout = new QFormLayout;
   AddressLayout->addRow("&Remote Address", IPAddress);
   
   Port = new QSpinBox(SocketWindow);
   Port->setRange(0,65535);
   Port->setValue(3492);
   Port->setToolTip("Port number of socket server");
   PortLayout = new QFormLayout;  
   PortLayout->addRow("&Port", Port);
  

    // Button to make connection
  Connect = new QPushButton("Connect", SocketWindow);
  Connect->setFont(QFont("Times", 10, QFont::Bold));
  connect(Connect, SIGNAL(clicked()), this, SLOT(MakeConnection()));
  Connect->setToolTip("Connect to server");
  SocketButton = new QPushButton("Socke&t\nInterface",this);
  SocketButton->setFont(QFont("Times", 10, QFont::Bold));
  connect(SocketButton, SIGNAL(clicked()), this, SLOT(OpenSocketWindow()));
  SocketButton->setToolTip("Open window for socket communication");


  connect(SocketButton, SIGNAL(clicked()), this, SLOT(OpenSocketWindow()));
  QPushButton *quit = new QPushButton(tr("Quit"));
  quit->setFont(QFont("Times", 18, QFont::Bold));
  Command = new QLineEdit(SocketWindow);
  CommandLayout = new QFormLayout;  
  CommandLayout->addRow("&Command", Command);
  Command->setEnabled(false);
  connect(Command, SIGNAL(returnPressed()), this, SLOT(SendToSocket()));
  Command->setToolTip("Command to send to socket server");

   // Text box for socket output
  SocketOutput= new QPlainTextEdit(SocketWindow);
  SocketOutput->setReadOnly(true);
  SocketOutput->setMaximumBlockCount(MAX_OUTPUT_LINES);
  SocketOutput->setToolTip("Output of socket server");

 // Layout of all widgets
  SocketLayout = new QGridLayout(SocketWindow);
  SocketLayout->addLayout(AddressLayout, 0, 0, 0, 1);
  SocketLayout->addLayout(PortLayout, 0, 2);
  SocketLayout->addWidget(Connect, 0, 3);
  SocketLayout->addLayout(CommandLayout, 1, 0, 1, 4);
  SocketLayout->addWidget(SocketOutput, 2, 0, 4, 4);  

  connect(quit, SIGNAL(clicked()), qApp, SLOT(quit()));

      QGridLayout *grid = new QGridLayout;

    
     pixels = new Tpixel*[36];
     
     int i=0;
     for( int row = 0 ; row <6 ; row++ ) 
       {
	 for( int col = 0 ; col < 6 ; col++) 
	   {

	   
	     //int i=row+6*col;
	     pixels[i] = new Tpixel;
	     grid->addWidget(pixels[i], row+1, col+1);
	     
	     //pixels[i]->setValue((int)((i)*255./36.));
	     pixels[i]->setValue((int)(0));
	     pixels[i]->setMaxVal(1000);
	     pixels[i]->setMinimumSize ( 50, 50 );	 
	     pixels[i]->setMaximumSize ( 50, 50 );	 
	     i++;
	   }
	 
       }

     humidity = new Humidity*[1];
     humidity[0] = new Humidity;
     
     humidity[0]->setMaxVal(100);
     humidity[0]->setMinVal(0);
     humidity[0]->setValue((int)(50));
     humidity[0]->setMinimumSize ( 70, 40 );	 
     humidity[0]->setMaximumSize ( 70, 40 );
     tempsens=new Tempsens*[7];
     for(int j=0;j<7;j++)
       {
	 tempsens[j]=new Tempsens;
	 tempsens[j]->setMaxVal(35);
	 tempsens[j]->setMinVal(5);
	 tempsens[j]->setValue((int)(5+j));
	 tempsens[j]->setMinimumSize ( 70, 70 );	 
	 tempsens[j]->setMaximumSize ( 70, 70 );
       }
     QHBoxLayout *hlay = new QHBoxLayout;
     //hlay->addWidget(tempsens[0]);
     hlay->addWidget(SocketButton);
     hlay->addWidget(quit);
     //hlay->addWidget(tempsens[1]);
     grid->addWidget(tempsens[0],0,0);
     grid->addWidget(tempsens[1],0,7);
     grid->addWidget(tempsens[2],7,0);
     grid->addWidget(tempsens[3],7,7);
     tempsens[4]->setMinimumSize ( 70, 50 );	 
     tempsens[5]->setMinimumSize ( 70, 50 );	 
     grid->addWidget(tempsens[4],1,8);
     grid->addWidget(tempsens[5],5,8);

     QVBoxLayout *humlay = new QVBoxLayout;
  
     tempsens[6]->setMinimumSize ( 70, 40 );	 
     tempsens[6]->setMaximumSize ( 70, 40 );
     humlay->addWidget(humidity[0]);
     humlay->addWidget(tempsens[6]);
     humlay->setSpacing (0); 
     //humlay->setVerticalSpacing(0) ;
     grid->addLayout(humlay,2,8,3,1);
 
     //grid->addWidget(tempsens[6],4,8);

     QVBoxLayout *layout = new QVBoxLayout;
     layout->addLayout(hlay);
     //layout->addWidget(SocketButton);
     layout->addLayout(grid);

     //layout->setColumnStretch(1, 10);

     setLayout(layout);

     //a time to update the pixel rates every 5 seconds:
     QTimer *timer = new QTimer(this);
     connect(timer, SIGNAL(timeout()),this , SLOT(updateRates()));
     
     timer->start(7000);




 }
void MyWidget::updateRates()
{
  if(Socket->state() == QAbstractSocket::ConnectedState)
    {
      char command[]= "V560 GetRates 1 \n\0";
      SocketOutput->insertPlainText(command);
      Socket->write(command);
      //QByteArray   bytes  = command.toAscii();
      //const char * ptr    = bytes.data();
      printf(command);

      //usleep(3000000);
      //SleeperThread::msleep(1000);

      /*const char tmp[]="V560 GetRate 1 5 \n\0";
      printf(tmp);
      Socket->write(tmp);
      SocketOutput->insertPlainText(tmp);*/
	
	      
    }
}
// +++ Open sub window handling the socket interface +++
void MyWidget::OpenSocketWindow() {
  SocketWindow->show();

  //  if(SocketWindow->isVisible()) SocketWindow->hide();
  //else SocketWindow->show();
}

// +++ Acquire data through socket (acquire botton only available if socket exists) +++
void MyWidget::GetSignalFromSocket() {
  char Command[MAX_COM_SIZE];

  GetButton->setEnabled(false);
  WaitForData = true;
  sprintf(Command, "test");//, BoardNo->value(), ChannelNo->value()/10, ChannelNo->value()%10);
  Socket->write(Command);
}

// Quit application when clicking close button on window


// +++ Connecting or disconnecting from client +++
void MyWidget::MakeConnection() {
  printf("Connecting...\n");
  if(Socket->state() == QAbstractSocket::ConnectedState) {
    ManualDisconnect = true;
    Socket->disconnectFromHost();
    Connect->setText("Connect");
  }
  else {
     
    Socket->connectToHost(IPAddress->text(),Port->value());


    
    Connect->setEnabled(false);  // While waiting for connection, button not available
    Socket->waitForConnected(SOCKET_TIMEOUT);
    Connect->setEnabled(true);
    if(Socket->state() != QAbstractSocket::ConnectedState)
      QMessageBox::warning(this, "MyWidget Message","Could not connect to host.",QMessageBox::Ok);
    else {
      //Connect->setText("Disconnect");
      //ConnectAction->setText("Disconnect");
      Port->setEnabled(false);
      IPAddress->setEnabled(false);
      Command->setEnabled(true);
      //GetButton->setEnabled(true);
      ManualDisconnect = false;
      Connect->setText("Disconnect");

      /*      OpenAction->setEnabled(false);      
      FilenameBox->setEnabled(false);
      LoadButton->setEnabled(false);
      FilenameBox->clear();
      CloseDatafile();*/

      /*      ChannelNo->setEnabled(true);
      BoardNo->setEnabled(true);
      PixelID->setEnabled(true);
      ChannelNo->setRange(0, 65535);
      BoardNo->setRange(0, 65535);
      
      TabWidget->setTabEnabled(1,false);
      TabWidget->setTabEnabled(2,false);

      RunHeaderDisplay->clear();
      EventHeaderDisplay->clear();
      Signal->hide();*/
    }
  }
}

// +++ Send command to socket (command button available only if socket existing) +++
void MyWidget::SendToSocket() {
  // QMessageBox::warning(this, "sdfsdf","sending to socket...",QMessageBox::Ok);
  //QString
  /*int length = strlen(Command->text().toAscii());
  printf("send length: %i\n", length);
  char buf[4];

  buf[0] = (char) length;
  buf[1] = (char) length >> 8;
  buf[2] = (char) length >> 16;
  buf[3] = (char) length >> 24;


  Socket->write(buf);*/
  Socket->write(Command->text().toAscii());
  Command->clear();
}

// +++ Read data from socket and display +++
void MyWidget::ParseData(QString data)
{
  data = data.remove(QChar('['));
  data = data.remove(QChar(']'));
data = data.remove(QChar('\ '));
  data = data.trimmed();
  QStringList list1 = data.split(",",QString::SkipEmptyParts);
  int numberofelements = list1.count();
  printf("%i\n",numberofelements);
  numberofelements--;
  
  if(list1[0]=="Temp")
    {
      printf("updating temp...\n");
      list1.removeAt(0);
      float temperature[numberofelements];
      if (numberofelements>7) numberofelements = 7;
      for(int i =0;i<numberofelements;i++)
	{ 
	  temperature[i]= list1[i].toFloat();
	  QString stri;
	  stri=QString("%1").arg(ListToTemperaturePixel[i]);
	  
	  QString output = "Setting temperature of sensor  "+stri + " to " + list1[i]+"c\n";
	  SocketOutput->insertPlainText(output);
	  tempsens[ListToTemperaturePixel[i]]->setValue((float)(temperature[i]));
	}
      temperature[7]= list1[7].toFloat();
      humidity[0]->setValue(temperature[7]);
      //printf("hum: %i\n",temperature[7]);
    }
  if(list1[0]=="\'rates\'")
    {
      list1.removeAt(0);
      float rates[numberofelements];
      for(int j =0;j<numberofelements;j++)
	{
	  // pixels[j]->setMaxVal(1);
	}
      for(int i =0;i<numberofelements;i++)
	{ 
	  
	  rates[i]= list1[i].toFloat();
	  QString stri;
	  stri=QString("%1").arg(PixelToTriggerPixel[i]);
	  
	  QString output = "Setting rates of trigger pixel "+stri + " to " + list1[i]+"\n";
	  SocketOutput->insertPlainText(output);
	  pixels[PixelToTriggerPixel[i]]->setValue((int)(rates[i]));
	  /*if(rates[i]>pixels[i]->getMaxVal())
	    {
	    for(int j =0;j<numberofelements;j++)
	    {
	    pixels[j]->setMaxVal(rates[i]);
	    }
	    
	    }*/
	  // pixels[i]->setMaxVal(255);
	}
    }


}
void MyWidget::ReadFromSocket() {
  // Check if channel data expected and error message arrived
  /*char Data[1024];
  printf("size of int: %i\n",sizeof(int));
  char cSize[sizeof(int)];
  int Size;
  
  int numBytes=Socket->read(cSize,sizeof(int));
  Size=(int)(cSize);
  printf ("numbytes: %i\n",numBytes);
  printf("csize: %x\n",cSize);
  printf("size: %i\n",Size);
  
  numBytes+http://www.google.ch/firefox?client=firefox-a&rls=org.mozilla:en-US:official=Socket->read(Data,Size);
  printf("Data:%s\n",Data);/**/

  //QByteArray command;
  char command[1024];
  Socket->read(command,1023);
  printf("cc: %s\n",command);
  QString temp(command);
  //SocketOutput->insertPlainText(command);
  if(temp[0]!=QChar('['))
    SocketOutput->insertPlainText(temp);
  else
    ParseData(temp);



   //QString qData(Data);

  //char * cData = Data.constData ();
  
  //if (WaitForData && Data.contains("Error")) {
  // WaitForData = false;
    //GetButton->setEnabled(true);
  // QMessageBox::warning(this, "MyWidget Message","Could not read waveform data from socket.",QMessageBox::Ok);
  // return;
  // }

  // Check if channel data were transmitted, if yes and waiting for data, extract and plot them
  /*printf("num bytes: %i",numBytes);
   QString temp(numBytes);
   SocketOutput->insertPlainText(temp);
   SocketOutput->insertPlainText(Data);
   SocketOutput->insertPlainText("TTT");
  printf("Data\n");
  printf("%s",Data);*/
  //QString Text = SocketOutput->document()->toPlainText().trimmed();
  /*usleep(100000);	// Wait to limit maximum update rate
  GetSignalFromSocket();*/
  /*if (WaitForData && Text.endsWith(QLatin1String("==END=="))) {
    // Extract text between ==START== and ==END==
    QByteArray Data=Text.mid(Text.lastIndexOf("==START==")+9,Text.length()-Text.lastIndexOf("==START==")-16).toAscii();

    char *NextNumber = strtok(Data.data()," ");  // Number of entries that follow
    int Count=0, NumberOfEntries = atoi(NextNumber);
    double *x = new double [NumberOfEntries];
    double *y = new double [NumberOfEntries];

    // Convert all entries (separated by a whitespace) to numbers
    while((NextNumber=strtok(NULL, " "))!=NULL && Count<NumberOfEntries)
      *(y+Count++) = atof(NextNumber);
    if (Count==NumberOfEntries && NextNumber!=0)
      QMessageBox::warning(this, "MyWidget Message","Found too many numbers in data block, truncated.",QMessageBox::Ok);
    // Apply sampling frequency and scaling factor 
    for(int i=2; i<Count; i++) {
      x[i] = (i-2) / y[0];
      y[i] = y[i] * y[1];
    }
    if(NumberOfEntries>2) {
      Signal->setData(x+2, y+2, NumberOfEntries-2); // Copies data, arrays can be deleted afterwards
      Signal->show();
      Zoomer->setZoomBase(Signal->boundingRect());
    }  
    delete[] x;   delete[] y;

    if(ContinuousBox->isChecked()) {
      usleep(100000);	// Wait to limit maximum update rate
      GetSignalFromSocket();
    }
    else {
      WaitForData = false;
      GetButton->setEnabled(true);
    }
    }*/
}

// +++ Disconnect from socket +++
void MyWidget::GotDisconnected() {
  Connect->setText("Connect");
  //ConnectAction->setText("Connect");
  Port->setEnabled(true);
  IPAddress->setEnabled(true);
  Command->setEnabled(false);

  GetButton->setEnabled(false);
  /*FilenameBox->setEnabled(true);
  OpenAction->setEnabled(true);    
  LoadButton->setEnabled(true);
  ChannelNo->setEnabled(false);
  BoardNo->setEnabled(false);
  PixelID->setEnabled(false);
  Signal->hide();
  TabWidget->setTabEnabled(1, true);
  TabWidget->setTabEnabled(2, true);*/
  
  SocketOutput->clear();
  if(!ManualDisconnect) QMessageBox::warning(this, "MyWidget Message","Socket disconnected, maybe host gone.",QMessageBox::Ok);
}



 int main(int argc, char *argv[])
 {
     QApplication app(argc, argv);
     MyWidget widget;
     widget.resize(400,400);
     widget.show();
     return app.exec();
 }

