
#ifndef HVCONFIG_H_SEEN
#define HVCONFIG_H_SEEN

#include <time.h>

#include <string.h>

#include "Types.h"

class HVConfig {

 public:

  HVConfig(FILE* fptr, char *configfile=NULL);
  ~HVConfig();

  int ReadHVConfig(FILE* fptr, char *configfile);
  int PrintHVConfig(FILE* fptr);
  int WriteHVConfig(FILE* fptr, char *configfile);

  int NumHVBoards;
  int USBDeviceNumber[MAX_NUM_HVBOARDS];

  int fCCPort;
  char *fCCClient;

  bool TestMode;

  bool IsDAC;
  float Coef[MAX_NUM_HVBOARDS][MAX_NUM_CHAINS][2];
 
  char*  FileName;
  char*  fLogPath;
  char** fUSBDevice;

  char*  fPixMapTable;
 
  float  fTimeOut;
  float  fStatusRefreshRate;

  int DACMin;
  int DACMax;
  float HVMin;
  float HVMax;

  float  fHVCalibOffset;
  float  fHVCalibSlope;
  float  fHVMaxDiff;

};

#endif
