#ifndef MPEDCALCPEDRUN_H
#define MPEDCALCPEDRUN_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedCalcPedRun                                                          //
//                                                                         //
// Evaluate the pedestals from pedestal runs                               //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_H
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;
class MRawEvtPixelIter;

class MPedCalcPedRun : public MTask
{

    MRawEvtData  *fRawEvt;     // raw event data (time slices)
    MPedestalCam *fPedestals;  // Pedestals of all pixels in the camera

public:

    MPedCalcPedRun(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    Float_t PedMeanCalcHiGain(Byte_t *ptr, const Byte_t *end);
    Float_t PedRmsCalcHiGain(Byte_t *ptr, const Byte_t *end, Float_t HiGainPed);
    Float_t PedMeanErrCalcHiGain(Float_t HiGainRms);
    Float_t PedRmsErrCalcHiGain(Float_t HiGainRms);

    ClassDef(MPedCalcPedRun, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
