 void Pedestals_Stability()
{
    char *files[11] = {"ped_stab/stab1.root",
                      "ped_stab/stab2.root",
                      "ped_stab/stab3.root",
                      "ped_stab/stab4.root",
                      "ped_stab/stab5.root",
                      "ped_stab/stab6.root",
                      "ped_stab/stab7.root",
                      "ped_stab/stab8.root",
                      "ped_stab/stab9.root",
                      "ped_stab/stab10.root",
                      "ped_stab/stab11.root"};

    for (Int_t stab_f=0; stab_f<11; stab_f++){

      MParList plist;

      MPedestalCam  pedest;
      MTaskList     tlist;

      plist->AddToList(&pedest);
      plist->AddToList(&tlist);

      MReadTree read("Events", files[stab_f] );
      MPedCalcPedRun pedcalc;

      tlist.AddToList(&read);
      tlist.AddToList(&pedcalc);

      MEvtLoop evtloop;
      evtloop.SetParList(&plist);

      if (!evtloop.PreProcess())
        return;

      const UInt_t NumEnt = read.GetEntries();

      Float_t pedmeantohist[8][NumEnt];
      Float_t pedMean[8][11];
      Float_t pedRMS[8][11];

      Int_t Ecount = 0;

      while (read.Process())
      {

        pedcalc.Process();

        for (Int_t i=0; i<8; i++){
          pedmeantohist[i][Ecount] = pedest[i].GetMean();
        }

	Ecount++;

      } 

      evtloop.PostProcess();


    // Create Histogram to get Mean & RMS per 100 pixel events
 
      gROOT->Reset();

      PixelHist = new TH1F("Pixel Hist","Pixel x - Ped hist",100,0,1000);

      cout << files[stab_f] << endl;

      for (Int_t pix=0; pix<8 ; pix++){
         for (Int_t ev=0; ev<NumEnt; ev++){
           PixelHist->Fill(pedmeantohist[pix][ev]);
        }
     
	 pedMean[pix][stab_f] = PixelHist->GetMean();
	 pedRMS[pix][stab_f] = PixelHist->GetRMS();

	 //        cout << "Px" << pix << " - Ped = " 
	 //	     << PixelHist->GetMean() << " +/- " << PixelHist->GetRMS() << endl;

        PixelHist->Reset();     

      }
    }


    // Plot the results

    // Create the Canvas

    c1 = new TCanvas("c1","Pedestals for all pixels",605,0,600,650);
    c1->Divide(3,3);

    for (Int_t pix=0; pix<8 ; pix++){

      Float_t Time[11] = {0,51,117,170,229,341,409,475,533,585,643};
      Float_t Err_Time[11];

      Float_t PedestMeantoGraph[11];
      Float_t PedestRMStoGraph[11];

      char Title[40];

       for (Int_t ev=0; ev<11; ev++){
	 PedestMeantoGraph[ev] = pedMean[pix][ev];
	 PedestRMStoGraph[ev] = pedRMS[pix][ev];
       }
       c1->cd(pix+1);
       gr = new TGraphErrors(11,Time,PedestMeantoGraph,Err_Time,PedestRMStoGraph);

       sprintf(Title,"Pedestal Stability - Pixel %d",pix+1);
       gr->SetMarkerStyle(20);
       gr->SetMarkerSize(0.7);
       gr->SetTitle(Title);
       gr->Draw("ALP");
       gr->GetXaxis()->SetTitle("Time (min)");
       gr->GetYaxis()->SetTitle("ADC Counts");
       gr->Draw("ALP");
    
    }
    c1->Update();

}
