#ifndef STARCATALOG_H
#define STARCATALOG_H

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif
#ifndef SAOFILE_H
#include "SaoFile.h"
#endif
#ifndef SLALIB_H
#include "Slalib.h"
#endif

#include "coord.h"

typedef unsigned char byte;

class StarCatalog
{
private:
    SaoFile *fSao;
    sort_t  *fSrt;
    int      fEntries;

    Slalib   sla;

//    double   fPhi;      // location of observatory
//    double   fElong;

    double   fPixSize;  // [rad/pix] size of one pixel
    double   fWidth;    // size of display
    double   fHeight;   //

    float    fLimitMag; // [M] limiting magnitude for display

    AltAz    fAltAz;    // [rad]
    byte     fAz0[360];
    int      fAltMin;
    int      fAltMax;
    int      fAzCnt;

    RaDec    fRaDec;    // [rad]
    byte     fRa0[360];
    int      fRaCnt;
    int      fDecMin;
    int      fDecMax;

//    double   fAlpha;
//    double   fMjd;
//    double   fAmprms[21];
//    double   fAoprms[14];

    void DrawCross(byte *img, const int x, const int y);
    void DrawCircle(int color, byte *img, int xx, int yy, int size);

    Bool_t DrawAltAz(const int color, byte *img, double alt, double az,  int size=0);
    Bool_t DrawRaDec(const int color, byte *img, double ra,  double dec, int size=0);

    Bool_t Draw(const int color, byte *img, const AltAz &altaz);
    Bool_t Draw(const int color, byte *img, const RaDec &radec);
    Bool_t Draw(const int color, byte *img, const SaoFile *sao);

    void   CalcImg(byte *);

    void   SetRaDec(const RaDec &radec);
    void   SetAltAz(const AltAz &altaz);
//    void   SetMjd(const double mjd);
    void   DrawSCAltAz(byte *img, const int color);
    void   DrawSCRaDec(byte *img, const int color);
  
    void   CalcRaDecRange();
    void   CalcAltAzRange();

//    RaDec  AltAz2RaDec(const AltAz &altaz) const;
//    AltAz  RaDec2AltAz(const RaDec &radec, const RaDec &rdpm) const;

public:
    StarCatalog();
    virtual ~StarCatalog();

    void   GetImg(byte *img, byte *cimg, const double utc,
                  const RaDec &radec);
    void   GetImg(byte *img, byte *cimg, const double utc,
                  const AltAz &altaz);

    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    const ZdAz  GetZdAz() const  { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    void  SetPixSize(const double pixsize);
    void  SetLimitMag(const float mag) { fLimitMag = mag; };
};

#endif
