#include <string>

#include <QtGui>
#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QAbstractSocket>

#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_plot_spectrogram.h>
#include <qwt_raster_data.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_color_map.h>

#include "../../drsdaq/RawDataCTX.h"
#include "../../pixelmap/PixelMap.h"

#define SOCKET_TIMEOUT 10000	// Milliseconds to wait for socket connection
#define MAX_OUTPUT_LINES 200	// Maximum number of lines in socket output window
#define MAX_COM_SIZE 10000
#define INITIAL_DIRECTORY ""

// Main window class
class ddd : public QMainWindow {
    Q_OBJECT

    QPushButton *GetButton, *SocketButton, *Connect, *M0Display;
    QCheckBox *ContinuousBox, *AutoscaleBox;
    QToolButton *LoadButton;
    QLineEdit *FilenameBox, *IPAddress, *Command, *PixelID;
    QSpinBox *EventNo, *ChannelNo, *BoardNo, *Port, *M0Start, *M0Stop;
    QPlainTextEdit *RunHeaderDisplay, *EventHeaderDisplay, *SocketOutput;
    QTabWidget *TabWidget;
    QTcpSocket *Socket;
    QWidget *SocketWindow, *Central, *M0Window;
    QAction *OpenAction, *ConnectAction;
    QGridLayout *SocketLayout, *MainLayout, *M0Layout;
    QVBoxLayout *GraphLayout;
    QFormLayout *CommandLayout, *PortLayout, *AddressLayout, *FormLayout, *SpinLayout, *M0StartLayout, *M0StopLayout;
    
    QwtPlot *Graph, *Graph2D;
    QwtPlotZoomer *Zoomer;
    QwtPlotCurve *Signal;
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotSpectrogram *Signal2D;
    QwtLinearColorMap colorMap;
    
    void closeEvent(QCloseEvent *); 

    bool ManualDisconnect, WaitForData;
    RawDataCTX *RD;
    PixelMap *PixMap;
    FILE *Tmpfile;
      
  public:
    ddd();
    ~ddd();
    void CloseDatafile();
    
  private slots:
    void OpenDatafile();
    void DisplayEvent(int=0);
    void FileDialog();
    void OpenSocketWindow();
    void OpenM0Window();
    void GetSignalFromSocket();
    void MakeConnection();
    void SendToSocket();
    void ReadFromSocket();
    void GotDisconnected();
    void TranslatePixelID();
    
    void MenuSave();
    void MenuPrint();
    void MenuHelp();
    void MenuAbout();
};

//Data class for 2D spectrogram (MO display specific)
class SpectrogramDataM0: public QwtRasterData {

private:

    double _z[6][6];
    double _zmin;
    double _zmax;

public:
    
    SpectrogramDataM0(const double z[6][6]): QwtRasterData(QwtDoubleRect(0, 0, 6, 6)) {
	for (int i = 0; i<6; i++){
	  for (int j = 0; j<6; j++){
	      _z[i][j] = z[i][j];
	      if (z[i][j] > _zmax) _zmax = z[i][j];
	      if (z[i][j] < _zmin) _zmin = z[i][j];
	   }
	}
    }

    virtual QwtRasterData *copy() const {
	return new SpectrogramDataM0(_z);
    }

    virtual QwtDoubleInterval range() const {
        return QwtDoubleInterval(_zmin, _zmax);
    }

    virtual void initRaster(const QwtDoubleRect = QwtDoubleRect(0, 0, 6, 6),
			    const QSize =QSize(1,1)) {};	 
	 	
    virtual double value(double x, double y) const {

	unsigned int first = (unsigned int)x;
	unsigned int second = (unsigned int)y;

	const double v = _z[first][second];
        return v;

    }

};
