/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 2/2007 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2007
!
!
\* ======================================================================== */

void mirrordelay()
{
    TF1 fpar("Parab",  "[0]*x*x");
    TF1 fsph("Sphere", "-sqrt([0]*[0] - x*x)+[0]");

    Double_t F = 4.5; // Fokallaenge = 1/4a
    Double_t D = 4.5; // Mirror Diameter
    Double_t x = 1.85;

    fsph.SetRange(-D*0.55, D*0.55);
    fpar.SetRange(-D*0.55, D*0.55);

    fpar.SetParameter(0, 1./(4*F));
    fsph.SetParameter(0, F);

    fpar.SetMaximum(F*1.05);

    TCanvas *c = new TCanvas;

    TF1 *f = (TF1*)fpar.DrawClone();
    fsph.DrawClone("same");

    f->GetXaxis()->SetTitle("x [m]");
    f->GetYaxis()->SetTitle("y [m]");
    f->GetXaxis()->CenterTitle();

    TArrow l;
    l.SetLineColor(kBlue);
    l.DrawArrow(-x, F*1.05, -x, fsph.Eval(-x), 0.02);
    l.DrawArrow( x, F*1.05,  x, fsph.Eval( x), 0.02);
    l.SetLineColor(kRed);
    l.DrawArrow(-x, fsph.Eval(-x), -x, fpar.Eval(-x), 0.02);
    l.DrawArrow( x, fsph.Eval(-x),  x, fpar.Eval( x), 0.02);
    l.DrawArrow(-x, fpar.Eval(-x), 0, F, 0.02);
    l.DrawArrow(-x, fsph.Eval(-x), 0, F, 0.02);
    l.DrawArrow( x, fpar.Eval( x), 0, F, 0.02);
    l.DrawArrow( x, fsph.Eval( x), 0, F, 0.02);

    TMarker m;
    m.SetMarkerStyle(kStar);
    m.DrawMarker(0, F);

    c = new TCanvas;
    c->SetGridx();
    c->SetGridy();

    TF1 del("Diff", "(Sphere-Parab+TMath::Hypot(x-0, Parab-[0])-[0])/3e8*1e9");
    del.SetParameter(0, F);

    del.SetRange(-D*0.55, D*0.55);
    f = (TF1*)diff.DrawClone();

    f->GetXaxis()->SetTitle("x [m]");
    f->GetYaxis()->SetTitle("delay [ns]");
    f->GetXaxis()->CenterTitle();
}
