void getThreshold( char* filename = "/hdb1/users/jlopez/temp_loop.root")
{

  // This macro fill the container MMcEnerThre using the task
  // MMcEnerThreCalc and shows the results.

  MParList parlist;
  MTaskList tasklist;

  // Setup the parameter list
  // - You need create the container MMcEnerThre.
  //     You need to put the number of trigger conditions when
  //      you declarete the MMcEnerThre
  //     If you don't put any dimension to MMcEnerThre it works
  //      taking only the trigger information from MMcTrig
  // - You can control the number of bins in the energy distribution
  //   histogram used to compute the energy threshold using 
  //   the SetBins() function.

  Int_t NumTrigCond = 5;
  MMcEnerThre enerthre(NumTrigCond);
  enerthre[0].SetBins(60);
  enerthre[1].SetBins(60);
  enerthre[2].SetBins(60);
  enerthre[3].SetBins(60);
  enerthre[4].SetBins(60);

  parlist.AddToList(&tasklist);
  parlist.AddToList(&enerthre);

  // Setup the task list
  // - You need the read and the MMcEnerThreCalc tasks
  //     You need to put the number of trigger conditions when
  //      you declarete the MMcEnerThreCalc
  //     If you don't put any dimension to MMcEnerThreCalc it works
  //      like one dimension MMcEnerThreCalc



  MReadTree read("Events",filename);

  MMcEnerThreCalc enerthrecalc(NumTrigCond);
  
  tasklist.AddToList(&read);
  tasklist.AddToList(&enerthrecalc);

  MEvtLoop evtloop;
  evtloop.SetParList(&parlist);

  // Begin the loop

  evtloop.Eventloop();

  // Now you can display the results

  gROOT->Reset();

  c0= new TCanvas("c0","Energy distribution for triggered events",50,50,850,550);
  enerthre[0].Print();
  enerthre[0].Draw();
  c0->Update();

  c1= new TCanvas("c1","Energy distribution for triggered events",50,50,850,550);
  enerthre[1].Print();
  enerthre[1].Draw();
  c1->Update();

  c2= new TCanvas("c2","Energy distribution for triggered events",50,50,850,550);
  enerthre[2].Print();
  enerthre[2].Draw();
  c2->Update();

  c3= new TCanvas("c3","Energy distribution for triggered events",50,50,850,550);
  enerthre[3].Print();
  enerthre[3].Draw();
  c3->Update();

  c4= new TCanvas("c4","Energy distribution for triggered events",50,50,850,550);
  enerthre[4].Print();
  enerthre[4].Draw();
  c4->Update();

}




