<?php

//arrays and functions for plot.php and plotdb.php
include("include.php");
include("magicdefs.php");
include("db.php");

$tables=array("fSequenceFirst" => "Sequences",
              "fRunNumber"     => "RunData",
              "fDataSetNumber" => "DataSets");

$prims=array("SequenceNumber" => "fSequenceFirst",
             "RunNumber"      => "fRunNumber",
             "DataSetNumber"  => "fDataSetNumber");

$joins=array("fSequenceFirst" => " LEFT JOIN Star ON Star.fSequenceFirst=Sequences.fSequenceFirst "
             ."LEFT JOIN Calibration ON Calibration.fSequenceFirst=Sequences.fSequenceFirst",
             "fRunNumber" => " LEFT JOIN DataCheck ON DataCheck.fRunNumber=RunData.fRunNumber ",
             "fDataSetNumber" =>" LEFT JOIN Ganymed ON Ganymed.fDataSetNumber=DataSets.fDataSetNumber");

function GetList($host, $user, $pw, $db, $column, $tables)
{
    $tab_fSequenceFirst=array("Sequences", "Calibration", "Star");
    $tab_fRunNumber=array("RunData");
    $tab_fDataSetNumber=array("DataSets", "Ganymed");

    $table=$tables[$column];
    foreach(${"tab_".$column} as $tab)
    {
        $query="EXPLAIN " . $tab;

        mysql_connect($host, $user, $pw);
        mysql_select_db($db);

        $result=mysql_query($query);

        while ($row = mysql_fetch_row($result))
            $list[] = $row[0];
    }
    return $list;
}

function GetQuery($tables, $joins, $set)
{
    if (empty($_GET["prim"]))
        $_GET["prim"]="";
    $primary=$_GET["prim"];
    if (empty($primary))
        return "";
    if (empty($_GET[$primary."Col"]))
        $_GET[$primary."Col"]="";
    $column=$_GET[$primary."Col"];
    $table=$tables[$primary];
    if (empty($_GET["primstart"]))
        $_GET["primstart"]="";
    $primstart=$_GET["primstart"];
    if (empty($_GET["primstop"]))
        $_GET["primstop"]="";
    $primstop=$_GET["primstop"];
    if (empty($_GET[$column."Start"]))
        $_GET[$column."Start"]="";
    $start1=$_GET[$column."Start"];
    if (empty($_GET[$column."Stop"]))
        $_GET[$column."Stop"]="";
    $stop1=$_GET[$column."Stop"];

    $query="SELECT " . $table . "." . $primary . ", ";
    if ($column==$primary)
        $query.=$table . "." . $column;
    else
        $query.=$column;

    if ($_GET["plot"]=="val")
    {
        if (empty($_GET[$primary."Col2"]))
            $_GET[$primary."Col2"]="";
        $column2=$_GET[$primary."Col2"];
        if (empty($_GET[$column2."Start2"]))
            $_GET[$column2."Start2"]="";
        $start2=$_GET[$column2."Start2"];
        if (empty($_GET[$column2."Stop2"]))
            $_GET[$column2."Stop2"]="";
        $stop2=$_GET[$column2."Stop2"];

        if ($column2==$primary)
            $query.=", " . $table . "." . $column2;
        else
            $query.=", " . $column2;
    }
    $query.=" FROM " . $table;
    $query.=$joins[$primary];
    if (!empty($primstart) && !empty($primstop))
        $query.=" WHERE " . $table . "." . $primary . " BETWEEN " . $primstart . " AND " . $primstop;

    if (!empty($start1) && !empty($stop1))
    {
        if (strpos($query, " WHERE ")==FALSE)
            $query.=" WHERE " . $column . " BETWEEN " . $start1 . " AND " . $stop1;
        else
            $query.=" AND " . $column . " BETWEEN " . $start1 . " AND " . $stop1;
    }

    if ($_GET["plot"]=="val" && !empty($start2) && !empty($stop2))
    {
        if (strpos($query, " WHERE ")==FALSE)
            $query.=" WHERE " . $column2 . " BETWEEN " . $start2 . " AND " . $stop2;
        else
            $query.=" AND " . $column2 . " BETWEEN " . $start2 . " AND " . $stop2;
    }

    if (!empty($set) && !empty($_GET[$set]))
    {
        if (strpos($query, " WHERE ")==FALSE)
            $query .= " WHERE ";
        else
            $query.=" AND ";
        $query.= $table . "." . $primary . " IN (" . str_replace(" ", ",", $_GET[$set]) . ") ";
    }

    return $query;
}

//functions for showplots.php and showplots2.php
function gettypename($type2)
{
    switch ($type2)
    {
    case "calib":
        $type="callisto";
        break;
    case "signal":
        $type="callisto";
        break;
    case "star":
        $type="star";
        break;
    }
    return $type;
}

function getplotname($seq, $tabnum, $type, $type2)
{
    $seqlong=str_pad($seq, 8, "0", STR_PAD_LEFT);
    $seqshort=substr($seqlong, 0, 4);
    $plot  = "http://datacenter.astro.uni-wuerzburg.de/";
    $plot .= $type . "/" . str_pad( $seqshort, 4, "0", STR_PAD_LEFT);
    $plot .= "/" . $seqlong . "/" . $type2 . $seqlong . "-tab" . $tabnum . ".png";
    return $plot;
}

?>
