#ifndef MARS_MPointingPositionCalc
#define MARS_MPointingPositionCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MPointingDev;
class MReportStarguider;

class MPointingDevCalc : public MTask
{
private:
    MReportStarguider *fReport;    //! MReportStarguider to get mispointing
    MPointingDev      *fDeviation; //! Output container to store pointing deviation

    UShort_t fRunType;             //! Run Type to decide where to get pointing position from

    Double_t fNsbSum;              //! Sum of Nsb from Starguider
    Double_t fNsbSq;               //! Sum of Sq of Nsb from Starguider
    Int_t    fNsbCount;            //! Counter of Nsb entries from Starguider

    TArrayI  fSkip;                //! Counter for execution statistics
    Double_t fLastMjd;             //! Time of last processed report

    UInt_t  fNumMinStars;          // Minimum number of identified stars
    Float_t fNsbLevel;             // Minimum deviation from mean in sigma
    Float_t fNsbMin;               // Minimum NSB to calc mean and rms
    Float_t fNsbMax;               // Maximum NSB to calc mean and rms
    Float_t fMaxAbsDev;            // [arcmin] Maximum considered absolute deviation
    Float_t fMaxAge;               // [min] Maximum age of reports to be used without an update

    Float_t fDx;                   // Starguider calibration dx
    Float_t fDy;                   // Starguider calibration dy

    // MPointingDevCalc
    Int_t ProcessStarguiderReport();
    void  Skip(Int_t i);

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    // MTask
    Bool_t ReInit(MParList *plist);
    Int_t  PreProcess(MParList *plist);
    Int_t  Process();
    Int_t  PostProcess();

public:
    MPointingDevCalc() : fReport(0), fDeviation(0), fSkip(7), fNumMinStars(8),
        fNsbLevel(3), fNsbMin(30), fNsbMax(60), fMaxAbsDev(15), fMaxAge(1), fDx(-7), fDy(16)
    {
        fName  = "MPointingDevCalc";
        fTitle = "Task calculating the pointing deviation";

        AddToBranchList("MReportStarguider.*");
    }

    void SetNumMinStars(UInt_t n)  { fNumMinStars=n; }
    void SetNsbLevel(Float_t lvl)  { fNsbLevel=lvl;  }
    void SetNsbMin(Float_t nsb)    { fNsbMin=nsb;    }
    void SetNsbMax(Float_t nsb)    { fNsbMax=nsb;    }
    void SetMaxAbsDev(Float_t max) { fMaxAbsDev=max; }
    void SetDx(Float_t dx)         { fDx=dx; }
    void SetDy(Float_t dy)         { fDy=dy; }
    void SetMaxAge(Float_t age)    { fMaxAge=age; }

    ClassDef(MPointingDevCalc, 0) //Task calculating the pointing deviation
};

#endif
