#ifndef MIMGCLEANSTD_H
#define MIMGCLEANSTD_H

#ifndef MAGIC_h
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;

class MImgCleanStd : public MTask
{
private:
    MGeomCam    *fCam;
    MCerPhotEvt *fEvt;

    Float_t fCleanLvl1;
    Float_t fCleanLvl2;

public:
    MImgCleanStd(const Float_t lvl1=3.0, const Float_t lvl2=2.5,
                 const char *name=NULL, const char *title=NULL);

    void CleanStep1();
    void CleanStep2();
    void CleanStep3();

    Bool_t PreProcess (MParList *pList);
    Bool_t Process();

    ClassDef(MImgCleanStd, 0)    // task doing a standard image cleaning
}; 

#endif

