#ifndef MHMCENERGIES_H
#define MHMCENERGIES_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif
#ifndef MHMCENERGY_H
#include "MHMcEnergy.h"
#endif

class MParList;

class MHMcEnergies : public MParContainer
{
private:
    UInt_t        fNum;
    TClonesArray *fHists; // histograms

public:

    MHMcEnergies(const UInt_t count=0, const char *name=NULL, const char *title=NULL);
    ~MHMcEnergies();

    void AddEntriesToList(MParList *plist);

    MHMcEnergy &operator[](UInt_t idx) { return (MHMcEnergy&)fHists[idx]; }

    ClassDef(MHMcEnergies, 1)  // container to hold several MHMcEnergy histograms
};

#endif
