#ifndef MTASK_H
#define MTASK_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTask                                                                   //
//                                                                         //
// Abstract base class for a task                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MINPUTSTREAMID_H
#include "MInputStreamID.h"
#endif

class MFilter;
class MParList;

class MTask : public MInputStreamID
{
private:
    const MFilter *fFilter;

public:
    MTask() : fFilter(NULL) {}
    ~MTask()
    {
    }

    const MFilter *GetFilter() const { return fFilter; }
    void SetFilter(const MFilter *filter) { fFilter=filter; }

    virtual Bool_t PreProcess(MParList *pList);
    virtual Bool_t Process();
    virtual Bool_t PostProcess();

    ClassDef(MTask, 0)		//Abstract base class for a task
};

#endif
