#ifndef MTASKLIST_H
#define MTASKLIST_H

///////////////////////////////////////////////////////////////////////
//                                                                   //
// MTaskList                                                         //
//                                                                   //
// Collection of tasks to be processed in the eventloop              //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef ROOT_TOrdCollection
#include <TOrdCollection.h>
#endif
#ifndef MTASK_H
#include "MTask.h"
#endif

class MLog;
class MParList;
class MInputStreamID;

class MTaskList : public MTask
{
private:
    TOrdCollection fTasks;	// Container for the ordered list of different tasks
    MParList      *fParList;

public:
    MTaskList(const char *title=NULL);

    MTaskList(MTaskList &ts);

    void SetLogStream(MLog *log);

    Bool_t AddToList(MTask *task, const char *tType="All", MTask *where = NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *opt = "");

    ClassDef(MTaskList, 0)	//collection of tasks to be performed in the eventloop
};

#endif
