#ifndef MHSTARMAP_H
#define MHSTARMAP_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#ifndef ROOT_TH2
// what's the reason that we need this here? cint complains about it
// if it is missing...
#include <TH2.h>
#endif

class MHillas;

class MHStarMap : public MParContainer
{
private:
    TH2F *fStarMap;

public:
     MHStarMap(const char *name=NULL, const char *title=NULL);
    ~MHStarMap();

    void Fill(const MHillas *par);

    TH2F *GetHist()               { return fStarMap; }
    void Draw(Option_t *opt=NULL);

    ClassDef(MHStarMap, 1) // Container to hold 2-dim histogram (starmap)
};

#endif

