#ifndef MHMCENERGY_H
#define MHMCENERGY_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class TH1F;
class TF1;

class MHMcEnergy : public MParContainer
{
private:

    TH1F *hLogEner;  // histogram with the logarith of the energy
    TF1  *fLogEner;  // gausian function to fit the histogram

public:

    MHMcEnergy(const UInt_t idx=0, const char *name=NULL, const char *title=NULL);
    ~MHMcEnergy();

    Float_t GetThreshold() const;
    Float_t GetThresholdErr() const;

    Float_t GetGaussPeak() const;
    Float_t GetGaussSigma() const;

    void Fill(Float_t log10E, Float_t w);
    void Fit(Axis_t xxmin, Axis_t xxmax);
    void SetNumBins(Int_t nbins = 100);

    void Draw(Option_t* option = "");
    void Print(Option_t* option = NULL);

    ClassDef(MHMcEnergy, 1)  // Histogram container for montecarlo energy threshold
};

#endif
